<?php
class ControllerCatalogCiquickcontact extends Controller {
	private $error = array();

	public function index() {
		$this->db->query("CREATE TABLE IF NOT EXISTS `". DB_PREFIX ."ciquickcontact` (`ciquickcontact_id` int(11) NOT NULL AUTO_INCREMENT,`contact_name` varchar(255) NOT NULL,`contact_email` varchar(96) NOT NULL,`contact_enquiry` text NOT NULL,`ip` varchar(40) NOT NULL,`reply` tinyint(4) NOT NULL,`first_reply_subject` text NOT NULL,`first_reply_message` text NOT NULL,`first_reply_date` datetime NOT NULL,`date_added` datetime NOT NULL,PRIMARY KEY (`ciquickcontact_id`)) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=0");

		if(isset($this->request->get['store_id'])) {
			$store_id = $this->request->get['store_id'];
		}else{
			$store_id = 0;
		}

		$this->load->language('catalog/ciquickcontact');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('ciquickcontact', $this->request->post, $store_id);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('catalog/ciquickcontact', 'user_token=' . $this->session->data['user_token'], true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['button_list'] = $this->language->get('button_list');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_default'] = $this->language->get('text_default');
		$data['text_module_setting'] = $this->language->get('text_module_setting');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_left'] = $this->language->get('text_left');
		$data['text_right'] = $this->language->get('text_right');
		$data['text_minutes'] = $this->language->get('text_minutes');
		$data['text_seconds'] = $this->language->get('text_seconds');
		
		$data['entry_module_status'] = $this->language->get('entry_module_status');
		$data['entry_seconds'] = $this->language->get('entry_seconds');
		$data['entry_popup_reopen'] = $this->language->get('entry_popup_reopen');		
		$data['entry_layout'] = $this->language->get('entry_layout');		
		$data['entry_title'] = $this->language->get('entry_title');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_customer_subject'] = $this->language->get('entry_customer_subject');
		$data['entry_customer_message'] = $this->language->get('entry_customer_message');
		$data['entry_admin_email_status'] = $this->language->get('entry_admin_email_status');
		$data['entry_admin_email'] = $this->language->get('entry_admin_email');
		$data['entry_admin_subject'] = $this->language->get('entry_admin_subject');
		$data['entry_admin_message'] = $this->language->get('entry_admin_message');
		$data['entry_success_title'] = $this->language->get('entry_success_title');
		$data['entry_success_description'] = $this->language->get('entry_success_description');
		$data['entry_customer_email_status'] = $this->language->get('entry_customer_email_status');
		$data['entry_position'] = $this->language->get('entry_position');
		$data['entry_width'] = $this->language->get('entry_width');
		$data['entry_banner'] = $this->language->get('entry_banner');
		$data['entry_popup_status'] = $this->language->get('entry_popup_status');
		$data['entry_popup_reopen'] = $this->language->get('entry_popup_reopen');
		$data['entry_minutes'] = $this->language->get('entry_minutes');
		$data['entry_button'] = $this->language->get('entry_button');
		$data['entry_button_preview'] = $this->language->get('entry_button_preview');

		$data['alert_admin_email'] = $this->language->get('alert_admin_email');

		$data['const_names'] = $this->language->get('const_names');
		$data['const_short_codes'] = $this->language->get('const_short_codes');
		$data['const_logo'] = $this->language->get('const_logo');
		$data['const_store_name'] = $this->language->get('const_store_name');
		$data['const_store_link'] = $this->language->get('const_store_link');
		$data['const_name'] = $this->language->get('const_name');
		$data['const_email'] = $this->language->get('const_email');
		$data['const_message'] = $this->language->get('const_message');

		$data['legend_setting'] = $this->language->get('legend_setting');

		
		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_email'] = $this->language->get('tab_email');
		$data['tab_success_page'] = $this->language->get('tab_success_page');
		$data['tab_css'] = $this->language->get('tab_css');
		$data['tab_customer_email'] = $this->language->get('tab_customer_email');
		$data['tab_admin_email'] = $this->language->get('tab_admin_email');
		$data['tab_autoopen'] = $this->language->get('tab_autoopen');

		$data['help_module_status'] = $this->language->get('help_module_status');
		$data['help_layout'] = $this->language->get('help_layout');
		$data['help_customer_email_status'] = $this->language->get('help_customer_email_status');
		$data['help_position'] = $this->language->get('help_position');
		$data['help_width'] = $this->language->get('help_width');
		$data['help_minutes'] = $this->language->get('help_minutes');
		$data['help_seconds'] = $this->language->get('help_seconds');
		$data['help_popup_reopen'] = $this->language->get('help_popup_reopen');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['list_href'] = $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'], true);

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['title'])) {
			$data['error_title'] = $this->error['title'];
		} else {
			$data['error_title'] = '';
		}

		if (isset($this->error['popup_minutes'])) {
			$data['error_popup_minutes'] = $this->error['popup_minutes'];
		} else {
			$data['error_popup_minutes'] = '';
		}

		if (isset($this->error['popup_seconds'])) {
			$data['error_popup_seconds'] = $this->error['popup_seconds'];
		} else {
			$data['error_popup_seconds'] = '';
		}

		if (isset($this->error['customer_subject'])) {
			$data['error_customer_subject'] = $this->error['customer_subject'];
		} else {
			$data['error_customer_subject'] = '';
		}

		if (isset($this->error['customer_message'])) {
			$data['error_customer_message'] = $this->error['customer_message'];
		} else {
			$data['error_customer_message'] = '';
		}

		if (isset($this->error['admin_email'])) {
			$data['error_admin_email'] = $this->error['admin_email'];
		} else {
			$data['error_admin_email'] = '';
		}

		if (isset($this->error['admin_subject'])) {
			$data['error_admin_subject'] = $this->error['admin_subject'];
		} else {
			$data['error_admin_subject'] = '';
		}

		if (isset($this->error['admin_message'])) {
			$data['error_admin_message'] = $this->error['admin_message'];
		} else {
			$data['error_admin_message'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/ciquickcontact', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['store_id'] = $store_id;
		if(isset($store_id)) {
			$data['action'] = $this->url->link('catalog/ciquickcontact', 'user_token=' . $this->session->data['user_token'] . '&store_id='. $store_id, true);
		} else{
			$data['action'] = $this->url->link('catalog/ciquickcontact', 'user_token=' . $this->session->data['user_token'], true);
		}

		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
			$ciquickcontact_info = $this->model_setting_setting->getSetting('ciquickcontact',  $store_id);
		}

		if (isset($this->request->post['ciquickcontact_status'])) {
			$data['ciquickcontact_status'] = $this->request->post['ciquickcontact_status'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_status'] = $ciquickcontact_info['ciquickcontact_status'];
		} else {
			$data['ciquickcontact_status'] = '';
		}

		if (isset($this->request->post['ciquickcontact_popup_status'])) {
			$data['ciquickcontact_popup_status'] = $this->request->post['ciquickcontact_popup_status'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_popup_status'] = $ciquickcontact_info['ciquickcontact_popup_status'];
		} else {
			$data['ciquickcontact_popup_status'] = '';
		}

		if (isset($this->request->post['ciquickcontact_position'])) {
			$data['ciquickcontact_position'] = $this->request->post['ciquickcontact_position'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_position'] = $ciquickcontact_info['ciquickcontact_position'];
		} else {
			$data['ciquickcontact_position'] = 'right';
		}

		if (isset($this->request->post['ciquickcontact_width'])) {
			$data['ciquickcontact_width'] = $this->request->post['ciquickcontact_width'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_width'] = $ciquickcontact_info['ciquickcontact_width'];
		} else {
			$data['ciquickcontact_width'] = '395px';
		}

		if (isset($this->request->post['ciquickcontact_css'])) {
			$data['ciquickcontact_css'] = $this->request->post['ciquickcontact_css'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_css'] = $ciquickcontact_info['ciquickcontact_css'];
		} else {
			$data['ciquickcontact_css'] = '';
		}

		if (isset($this->request->post['ciquickcontact_customer_email_status'])) {
			$data['ciquickcontact_customer_email_status'] = $this->request->post['ciquickcontact_customer_email_status'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_customer_email_status'] = $ciquickcontact_info['ciquickcontact_customer_email_status'];
		} else {
			$data['ciquickcontact_customer_email_status'] = '';
		}

		if (isset($this->request->post['ciquickcontact_admin_email_status'])) {
			$data['ciquickcontact_admin_email_status'] = $this->request->post['ciquickcontact_admin_email_status'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_admin_email_status'] = $ciquickcontact_info['ciquickcontact_admin_email_status'];
		} else {
			$data['ciquickcontact_admin_email_status'] = '';
		}

		if (isset($this->request->post['ciquickcontact_popup_minutes'])) {
			$data['ciquickcontact_popup_minutes'] = $this->request->post['ciquickcontact_popup_minutes'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_popup_minutes'] = $ciquickcontact_info['ciquickcontact_popup_minutes'];
		} else {
			$data['ciquickcontact_popup_minutes'] = 5;
		}

		if (isset($this->request->post['ciquickcontact_popup_seconds'])) {
			$data['ciquickcontact_popup_seconds'] = $this->request->post['ciquickcontact_popup_seconds'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_popup_seconds'] = $ciquickcontact_info['ciquickcontact_popup_seconds'];
		} else {
			$data['ciquickcontact_popup_seconds'] = 60;
		}

		if (isset($this->request->post['ciquickcontact_popup_reopen'])) {
			$data['ciquickcontact_popup_reopen'] = $this->request->post['ciquickcontact_popup_reopen'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_popup_reopen'] = $ciquickcontact_info['ciquickcontact_popup_reopen'];
		} else {
			$data['ciquickcontact_popup_reopen'] = '';
		}

		if (isset($this->request->post['ciquickcontact_admin_email'])) {
			$data['ciquickcontact_admin_email'] = $this->request->post['ciquickcontact_admin_email'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_admin_email'] = $ciquickcontact_info['ciquickcontact_admin_email'];
		} else {
			$data['ciquickcontact_admin_email'] = $this->config->get('config_email');
		}

		if (isset($this->request->post['ciquickcontact_description'])) {
			$data['ciquickcontact_description'] = $this->request->post['ciquickcontact_description'];
		} elseif (!empty($ciquickcontact_info['ciquickcontact_description'])) {
			$data['ciquickcontact_description'] = $ciquickcontact_info['ciquickcontact_description'];
		} else {
			$data['ciquickcontact_description'] = array();
		}

		if (isset($this->request->post['ciquickcontact_popup_layout'])) {
			$data['ciquickcontact_popup_layout'] = $this->request->post['ciquickcontact_popup_layout'];
		} elseif (!empty($ciquickcontact_info['ciquickcontact_popup_layout'])) {
			$data['ciquickcontact_popup_layout'] = (array)$ciquickcontact_info['ciquickcontact_popup_layout'];
		} else {
			$data['ciquickcontact_popup_layout'] = array();
		}

		if (isset($this->request->post['ciquickcontact_banner'])) {
			$data['ciquickcontact_banner'] = $this->request->post['ciquickcontact_banner'];
		} elseif (!empty($ciquickcontact_info)) {
			$data['ciquickcontact_banner'] = $ciquickcontact_info['ciquickcontact_banner'];
		} else {
			$data['ciquickcontact_banner'] = '';
		}

		$this->load->model('tool/image');
		if (isset($this->request->post['ciquickcontact_banner']) && is_file(DIR_IMAGE . $this->request->post['ciquickcontact_banner'])) {
			$data['banner'] = $this->model_tool_image->resize($this->request->post['ciquickcontact_banner'], 150, 150);
		} elseif ($this->config->get('ciquickcontact_banner') && is_file(DIR_IMAGE . $this->config->get('ciquickcontact_banner'))) {
			$data['banner'] = $this->model_tool_image->resize($this->config->get('ciquickcontact_banner'), 150, 150);
		} else {
			$data['banner'] = $this->model_tool_image->resize('no_image.png', 150, 150);
		}

		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 150, 150);


		$data['user_token'] = $this->session->data['user_token'];
		
		$this->load->model('setting/store');
		$data['stores'] = $this->model_setting_store->getStores();

		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();

		$this->load->model('design/layout');
		$data['layouts'] = $this->model_design_layout->getLayouts();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/ciquickcontact', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'catalog/ciquickcontact')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if(!empty($this->request->post['ciquickcontact_popup_reopen']) && !empty($this->request->post['ciquickcontact_popup_status']) && !empty($this->request->post['ciquickcontact_status'])) {
			if(!isset($this->request->post['ciquickcontact_popup_minutes']) || (int)$this->request->post['ciquickcontact_popup_minutes'] < '0') {
				$this->error['popup_minutes'] = $this->language->get('error_popup_minutes');
			}
		}

		if(!empty($this->request->post['ciquickcontact_popup_status']) && !empty($this->request->post['ciquickcontact_status'])) {
			if((int)$this->request->post['ciquickcontact_popup_seconds'] < '0') {
				$this->error['popup_seconds'] = $this->language->get('error_popup_seconds');
			}
		}

		foreach ($this->request->post['ciquickcontact_description'] as $language_id => $value) {
			if ((utf8_strlen($value['title']) < 2) || (utf8_strlen($value['title']) > 255)) {
				$this->error['title'][$language_id] = $this->language->get('error_title');
			}

			if(!empty($this->request->post['ciquickcontact_customer_email_status'])) {
				if ((utf8_strlen($value['customer_subject']) < 2) || (utf8_strlen($value['customer_subject']) > 255)) {
					$this->error['customer_subject'][$language_id] = $this->language->get('error_customer_subject');
				}

				$value['customer_message'] = str_replace('&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '', $value['customer_message']);
				if ((utf8_strlen($value['customer_message']) < 25)) {
					$this->error['customer_message'][$language_id] = $this->language->get('error_customer_message');
				}
			}

			if(!empty($this->request->post['ciquickcontact_admin_email_status'])) {
				if(empty($this->request->post['ciquickcontact_admin_email'])) {
					$this->error['admin_email'] = $this->language->get('error_admin_email');
					$this->error['warning'] = $this->language->get('error_admin_email');
				}

				if ((utf8_strlen($value['admin_subject']) < 2) || (utf8_strlen($value['admin_subject']) > 255)) {
					$this->error['admin_subject'][$language_id] = $this->language->get('error_admin_subject');
				}

				$value['admin_message'] = str_replace('&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '', $value['admin_message']);
				if ((utf8_strlen($value['admin_message']) < 25)) {
					$this->error['admin_message'][$language_id] = $this->language->get('error_admin_message');
				}
			}
		}
		
		return !$this->error;
	}

	public function getlist() {
		$this->load->language('catalog/ciquickcontact');

		$this->document->setTitle($this->language->get('heading_title_list'));

		$this->load->model('catalog/ciquickcontact');

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}


		$data['export'] = $this->url->link('catalog/ciquickcontact/export', 'user_token=' . $this->session->data['user_token'], true);

		$data['user_token'] = $this->session->data['user_token'];

		$data['heading_title_list'] = $this->language->get('heading_title_list');
		
		$data['text_list'] = $this->language->get('text_list');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_email'] = $this->language->get('column_email');
		$data['column_telephone'] = $this->language->get('column_telephone');
		$data['column_comment'] = $this->language->get('column_comment');
		$data['column_product_name'] = $this->language->get('column_product_name');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_ip'] = $this->language->get('column_ip');
		$data['column_reply'] = $this->language->get('column_reply');
		$data['column_date_added'] = $this->language->get('column_date_added');
		$data['column_action'] = $this->language->get('column_action');

		$data['text_no_results'] = $this->language->get('text_no_results');		
		$data['text_confirm'] = $this->language->get('text_confirm');
		
		$data['button_view'] = $this->language->get('button_view');
		$data['button_reply'] = $this->language->get('button_reply');
		$data['button_export'] = $this->language->get('button_export');
		$data['button_settings'] = $this->language->get('button_settings');
		$data['button_delete'] = $this->language->get('button_delete');

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/ciquickcontact', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title_list'),
			'href' => $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		$data['delete'] = $this->url->link('catalog/ciquickcontact/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['ciquickcontact_lists'] = array();

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin'),
		);

		$ciquickcontact_total = $this->model_catalog_ciquickcontact->getTotalContactRequest($filter_data);

		$results = $this->model_catalog_ciquickcontact->getContactRequests($filter_data);

		foreach ($results as $result) {
			$data['ciquickcontact_lists'][] = array(
				'ciquickcontact_id' => $result['ciquickcontact_id'],
				'contact_name'  => $result['contact_name'],
				'contact_email' => $result['contact_email'],
				'reply_class'   => $result['reply'] ? 'success' : 'warning',
				'reply'     	=> $result['reply'] ? $this->language->get('text_yes') : $this->language->get('text_no'),
				'contact_enquiry' => utf8_substr(nl2br($result['contact_enquiry']), 0, 100) . '...',
				'ip'     		 => $result['ip'],
				'date_added'     => date($this->language->get('datetime_format'), strtotime($result['date_added'])),
				'info'           => $this->url->link('catalog/ciquickcontact/info', 'user_token=' . $this->session->data['user_token'] . '&ciquickcontact_id=' . $result['ciquickcontact_id'] . $url, true)
			);
		}
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_contact_name'] = $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . '&sort=contact_name' . $url, true);
		$data['sort_contact_email'] = $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . '&sort=contact_email' . $url, true);
		$data['sort_ip'] = $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . '&sort=ip' . $url, true);
		$data['sort_reply'] = $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . '&sort=reply' . $url, true);
		$data['sort_date_added'] = $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $ciquickcontact_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($ciquickcontact_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($ciquickcontact_total - $this->config->get('config_limit_admin'))) ? $ciquickcontact_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $ciquickcontact_total, ceil($ciquickcontact_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['extension_setting'] = $this->url->link('catalog/ciquickcontact', 'user_token=' . $this->session->data['user_token'], true);

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/ciquickcontact_list', $data));
	}

	public function info() {
		$this->load->language('catalog/ciquickcontact');

		$this->load->model('catalog/ciquickcontact');

		$data['text_list'] = $this->language->get('text_list');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_email'] = $this->language->get('column_email');
		$data['column_ip'] = $this->language->get('column_ip');
		$data['column_comment'] = $this->language->get('column_comment');
		$data['column_first_reply'] = $this->language->get('column_first_reply');
		$data['column_date_added'] = $this->language->get('column_date_added');

		if (isset($this->request->get['ciquickcontact_id'])) {
			$ciquickcontact_id = $this->request->get['ciquickcontact_id'];
		} else {
			$ciquickcontact_id = 0;
		}

		$ciquickcontact_info = $this->model_catalog_ciquickcontact->getContactRequest($ciquickcontact_id);

		if($ciquickcontact_info) {
			$data['contact_name'] = $ciquickcontact_info['contact_name'];
			$data['contact_email'] = $ciquickcontact_info['contact_email'];
			$data['contact_enquiry'] = nl2br($ciquickcontact_info['contact_enquiry']);
			$data['ip'] = $ciquickcontact_info['ip'];
			$data['date_added'] = date($this->language->get('datetime_format'), strtotime($ciquickcontact_info['date_added']));

			$data['first_reply_subject'] = $ciquickcontact_info['first_reply_subject'];
			$data['first_reply_message'] = html_entity_decode($ciquickcontact_info['first_reply_message'], ENT_QUOTES, 'UTF-8');
			$data['first_reply_date'] = date($this->language->get('datetime_format'), strtotime($ciquickcontact_info['first_reply_date']));


			$this->response->setOutput($this->load->view('catalog/ciquickcontact_info', $data));
		}
	}

	public function openreply() {
		$this->load->language('catalog/ciquickcontact');

		$this->load->model('catalog/ciquickcontact');

		$data['text_shortcodes'] = $this->language->get('text_shortcodes');

		$data['text_reply'] = $this->language->get('text_reply');
		$data['entry_subject'] = $this->language->get('entry_subject');
		$data['entry_message'] = $this->language->get('entry_message');
		
		$data['const_names'] = $this->language->get('const_names');
		$data['const_short_codes'] = $this->language->get('const_short_codes');
		$data['const_logo'] = $this->language->get('const_logo');
		$data['const_store_name'] = $this->language->get('const_store_name');
		$data['const_store_link'] = $this->language->get('const_store_link');
		$data['const_name'] = $this->language->get('const_name');
		$data['const_email'] = $this->language->get('const_email');
		$data['const_comment'] = $this->language->get('const_comment');
		
		$data['button_short_codes'] = $this->language->get('button_short_codes');
		$data['button_send'] = $this->language->get('button_send');
		$data['button_close'] = $this->language->get('button_close');

		if (isset($this->request->post['selected'])) {
			$selected_values = (array)$this->request->post['selected'];
		} else {
			$selected_values = array();
		}

		if($selected_values) {
			$data['selected_values'] = $selected_values;
			
			$data['text_reply'] = $this->language->get('text_reply');
			$this->response->setOutput($this->load->view('catalog/ciquickcontact_reply', $data));
		}
	}

	public function addreply() {
		$json = array();

		$this->load->language('catalog/ciquickcontact');

		$this->load->model('catalog/ciquickcontact');

		if (!$this->user->hasPermission('modify', 'catalog/ciquickcontact')) {
			$json['warning'] = $this->language->get('error_permission');
		}

		if (empty($this->request->post['ciquickcontact_ids'])) {
			$json['warning'] = $this->language->get('error_ciquickcontact_ids');
		}

		if ((utf8_strlen($this->request->post['subject']) < 2) || (utf8_strlen($this->request->post['subject']) > 255)) {
			$json['warning'] = $this->language->get('error_subject');
		}

		if ((utf8_strlen(trim($this->request->post['message'])) < 25)) {
			$json['warning'] = $this->language->get('error_message');
		}

		if(!$json) {
			$reply_data = array(				
				'ciquickcontact_ids'		=> isset($this->request->post['ciquickcontact_ids']) ? $this->request->post['ciquickcontact_ids'] : array(),
				'subject'		=> isset($this->request->post['subject']) ? $this->request->post['subject'] : '',
				'message'		=> isset($this->request->post['message']) ? $this->request->post['message'] : '',
			);

			$this->model_catalog_ciquickcontact->addReply($reply_data);

			$json['success'] = $this->language->get('text_success_reply');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function delete() {
		$this->load->language('catalog/ciquickcontact');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/ciquickcontact');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $ciquickcontact_id) {
				$this->model_catalog_ciquickcontact->deleteContactRequest($ciquickcontact_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('catalog/ciquickcontact/getlist', 'user_token=' . $this->session->data['user_token'] . $url, true));
		}

		$this->getList();
	}

	protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'catalog/ciquickcontact')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

	public function export() {
		$this->load->language('catalog/ciquickcontact');

		$this->load->model('catalog/ciquickcontact');

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		require_once(DIR_SYSTEM.'library/PHPExcel.php');

		$objPHPExcel = new PHPExcel();
		
		$objPHPExcel->setActiveSheetIndex(0);  

		$objPHPExcel->getProperties()->setCreator("CodingInspect")->setLastModifiedBy("CodingInspect")->setTitle("Quick Contact List")->setSubject("Quick Contact List")->setDescription("Quick Contact List - Request List")->setKeywords("Quick Contact List")->setCategory("Quick Contact List");		

		$filter_data = array(
			'sort'  => $sort,
			'order' => $order,
		);

		$i = 1;
		$ci_column = 'A';
		
		$objPHPExcel->getActiveSheet()->getStyle('1')->getFill()->applyFromArray(array(
			'type'			=> PHPExcel_Style_Fill::FILL_SOLID,
			'startcolor' 	=> array(
			'rgb' 			=> 'f4cb7b',
			),
		));
				
		$objPHPExcel->getActiveSheet()->getStyle('1')->applyFromArray(array(
			'font'  => array(
				'color' => array(
					'rgb' => '000000'
				),
				'bold'  => true,
			)
		));

		$objPHPExcel->getActiveSheet()->setCellValue($ci_column .$i, $this->language->get('column_name'))->getColumnDimension($ci_column)->setAutoSize(true); 
		$objPHPExcel->getActiveSheet()->getStyle($ci_column++ .$i)->getAlignment()->setWrapText(true);

		$objPHPExcel->getActiveSheet()->setCellValue($ci_column .$i, $this->language->get('column_email'))->getColumnDimension($ci_column)->setAutoSize(true); 
		$objPHPExcel->getActiveSheet()->getStyle($ci_column++ .$i)->getAlignment()->setWrapText(true);

		$objPHPExcel->getActiveSheet()->setCellValue($ci_column .$i, $this->language->get('column_comment'))->getColumnDimension($ci_column)->setAutoSize(true); 
		$objPHPExcel->getActiveSheet()->getStyle($ci_column++ .$i)->getAlignment()->setWrapText(true);		

		$objPHPExcel->getActiveSheet()->setCellValue($ci_column .$i, $this->language->get('column_ip'))->getColumnDimension($ci_column)->setAutoSize(true); 
		$objPHPExcel->getActiveSheet()->getStyle($ci_column++ .$i)->getAlignment()->setWrapText(true);

		$objPHPExcel->getActiveSheet()->setCellValue($ci_column .$i, $this->language->get('column_date_added'))->getColumnDimension($ci_column)->setAutoSize(true); 
		$objPHPExcel->getActiveSheet()->getStyle($ci_column++ .$i)->getAlignment()->setWrapText(true);

		$results = $this->model_catalog_ciquickcontact->getContactRequests($filter_data);

		$objPHPExcel->getActiveSheet()->setTitle(sprintf($this->language->get('file_title'), count($results)));
		
		foreach($results as $result) {
			$column_data = 'A'; $i++; 

			$objPHPExcel->getActiveSheet()->setCellValue($column_data .$i, $result['contact_name'])->getColumnDimension($column_data)->setAutoSize(true);
			$objPHPExcel->getActiveSheet()->getStyle($column_data++ .$i)->getAlignment()->setWrapText(true);			

			$objPHPExcel->getActiveSheet()->setCellValue($column_data .$i, $result['contact_email'])->getColumnDimension($column_data)->setAutoSize(true);
			$objPHPExcel->getActiveSheet()->getStyle($column_data++ .$i)->getAlignment()->setWrapText(true);
			

			$objPHPExcel->getActiveSheet()->setCellValue($column_data .$i, $result['contact_enquiry'])->getColumnDimension($column_data)->setAutoSize(true);
			$objPHPExcel->getActiveSheet()->getStyle($column_data++ .$i)->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->setCellValue($column_data .$i, $result['ip'])->getColumnDimension($column_data)->setAutoSize(true);
			$objPHPExcel->getActiveSheet()->getStyle($column_data++ .$i)->getAlignment()->setWrapText(true);

			$objPHPExcel->getActiveSheet()->setCellValue($column_data .$i, date($this->language->get('datetime_format'), strtotime($result['date_added'])))->getColumnDimension($column_data)->setAutoSize(true);
			$objPHPExcel->getActiveSheet()->getStyle($column_data++ .$i)->getAlignment()->setWrapText(true);
		}

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5'); 
		
		header('Content-Type: application/vnd.ms-excel'); 
		header('Content-Disposition: attachment;filename="Contact-List.xls"'); 
		header('Cache-Control: max-age=0'); 

		$objWriter->save('php://output');
		exit();
	}
}