<?php
class ControllerExtensionAnalyticsBingVerification extends Controller {
	private $error = array();

	public function index() {
		$labels =  $this->load->language('extension/analytics/bing_verification');
                
                foreach ($labels as $label_key => $label) {
		        $data[$label_key] = $label;
                }
                
		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			
			if (empty($this->request->post['analytics_bing_verification_status']['status']) || ($this->request->post['analytics_bing_verification_status']['status'] == '0')) {
                                $this->model_setting_setting->editSettingValue('analytics_bing_verification', 'analytics_bing_verification_status', 0, $this->request->get['store_id']);
                        } else {
			        $this->model_setting_setting->editSetting('analytics_bing_verification', $this->request->post, $this->request->get['store_id']);
                        }

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=analytics', true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}


		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_analytics'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=analytics', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/analytics/bing_verification', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true)
		);

		$data['action'] = $this->url->link('extension/analytics/bing_verification', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=analytics', true);
		
		$data['user_token'] = $this->session->data['user_token'];
				
		
		$data['settings'] = json_decode($this->model_setting_setting->getSettingValue('analytics_bing_verification_status', $this->request->get['store_id']), true);
                
                if (isset($data['settings']['status'])) {
                        $data['status'] = $data['settings']['status'];
                } else {
                        $data['status'] = 0;
                }

                if (isset($data['settings']['code'])) {
                        $data['code'] = $data['settings']['code'];
                } else {
                        $data['code'] = '';
                }
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/analytics/bing_verification', $data));
	}

	protected function validate() {
	        
                if($this->request->post['analytics_bing_verification_status']['status']){
                        if(empty($this->request->post['analytics_bing_verification_status']['code'])){
	                        $this->error['warning'] = $this->language->get('error_code');
	                }
	        }
	        
		if (!$this->user->hasPermission('modify', 'extension/analytics/bing_verification')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}
