<?php
class ControllerExtensionEventDSEOAnalyser extends Controller
{
    private $codename = 'd_seo_analyser';

    public function view_after(&$route, &$data, &$output)
    {
        $designer_data = array(
            'config' => $this->codename,
            'output' => &$output,
            'id' => 1
        );

        $vd_content = $this->load->controller('extension/d_visual_designer/designer', $designer_data);

        $html_dom = new d_simple_html_dom();
        $html_dom->load($output, $lowercase = true, $stripRN = false, $defaultBRText = DEFAULT_BR_TEXT);

        $html_dom->find('body', 0)->innertext .= $vd_content;

        $output = (string)$html_dom;
    }

    public function save_success_after(&$route, &$data)
    {
        $this->load->model('localisation/language');
        $this->load->model('extension/d_visual_designer/designer');
            
        $languages = $this->model_localisation_language->getLanguages();
            
        foreach ($languages as $language) {
            $field_name = rawurlencode("d_seo_analyser_setting[description][".$language['language_id']."]");
      
            $setting = json_decode(html_entity_decode($this->request->post['vd_content'][$field_name], ENT_QUOTES, 'UTF-8'), true);
                
            $content = $this->model_extension_d_visual_designer_designer->parseSetting($setting);

            $this->model_extension_d_visual_designer_designer->saveContent($content, $this->codename, 1, rawurldecode($field_name));
        }
        unset($this->session->data['vd_content']);
    }
}
