<?php
class ControllerExtensionModuleAVAutoImageAttribute extends Controller {
	private $error = array();

	public function install() {

    $this->load->model('setting/setting');
    $this->model_setting_setting->editSetting('AVAutoImageAttribute_setting', ['avautoimageattribute_status' => 1]);

		$this->load->model("setting/event");
 		$this->model_setting_event->addEvent("AVAutoImageAttribute", "catalog/view/product/product/after", "extension/module/avautoimageattribute");

	}

	public function uninstall() {
		
		$this->load->model("setting/event");
		$this->model_setting_event->deleteEventByCode("AVAutoImageAttribute");

		$this->load->model('setting/setting');
   	$this->model_setting_setting->deleteSetting('AVAutoImageAttribute_setting');
	
	}

	public function index() {
			
		$this->load->language('extension/module/avautoimageattribute');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_avautoimageattribute', $this->request->post);
			

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', 'SSL'));
		}

		$text_strings = array(
			'heading_title',
			'text_edit',
			'text_enabled',
			'text_disabled',
			'entry_status',
			'button_save',
			'button_cancel',
			'entry_attr_num',
			'entry_alt_template',
			'text_template_placeholder',
			'entry_available_items',
			'entry_empty_input'
		);

		foreach($text_strings as $text) {
			$data[$text] = $this->language->get($text);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['attr_num'])) {
			$data['error_attr_num'] = $this->error['attr_num'];
		} else {
			$data['error_attr_num'] = '';
		}

		if (isset($this->error['alt_template'])) {
			$data['error_alt_template'] = $this->error['alt_template'];
		} else {
			$data['error_alt_template'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/avautoimageattribute', 'user_token=' . $this->session->data['user_token'], true)
		);

		if (!isset($this->request->get['module_id'])) {
			$data['action'] = $this->url->link('extension/module/avautoimageattribute', 'user_token=' . $this->session->data['user_token'], true);
		} else {
			$data['action'] = $this->url->link('extension/module/avautoimageattribute', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], true);
		}
		
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		if (isset($this->request->post['module_avautoimageattribute']['attr_num'])) {
			$data['module_avautoimageattribute']['attr_num'] = $this->request->post['module_avautoimageattribute']['attr_num'];
		} else if(is_array($this->config->get('module_avautoimageattribute'))) {
			$data['module_avautoimageattribute']['attr_num'] = $this->config->get('module_avautoimageattribute')['attr_num'];
		} else {
			$data['module_avautoimageattribute']['attr_num'] = $this->config->get('module_avautoimageattribute_attr_num');
		}

		if (isset($this->request->post['module_avautoimageattribute']['alt_template'])) {
			$data['module_avautoimageattribute']['alt_template'] = $this->request->post['module_avautoimageattribute']['alt_template'];
		} else if(is_array($this->config->get('module_avautoimageattribute'))) {
			$data['module_avautoimageattribute']['alt_template'] = $this->config->get('module_avautoimageattribute')['alt_template'];
		} else {
			$data['module_avautoimageattribute']['alt_template'] = $this->config->get('module_avautoimageattribute_alt_template');
		}

		if (isset($this->request->post['module_avautoimageattribute_status'])) {
			$data['module_avautoimageattribute_status'] = $this->request->post['module_avautoimageattribute_status'];
		} else {
			$data['module_avautoimageattribute_status'] = $this->config->get('module_avautoimageattribute_status');
		}

		$data['module_avautoimageattribute']['status'] = $data['module_avautoimageattribute_status'];

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

/*		$data['banner'] = file_get_contents('http://studio-av.com/banner/banner.php');

		if(strlen($data['banner']) === 0)
			$data['banner'] = '';*/

		$this->response->setOutput($this->load->view('extension/module/avautoimageattribute', $data));
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/avautoimageattribute')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		return !$this->error;
	}

	public function change_powered($route, $args, &$output) {
		//if($this->request->get['route'] == 'extension/module/avautoimageattribute') {
			$output = '<footer id="footer"><a href="https://studio-av.com" target="blank">studio-av.com</a> &copy; 2020  All Rights Reserved.<br />Have a questions? <br /> visit our forum <a href="https://forum.studio-av.com" target="blank">studio-av.com</a><br /><br /></footer>';	
		//}
	}

}