<?php
/*
 *  location: admin/controller
 */
class ControllerExtensionModuleDGoogleAnalytics extends Controller {

    public $extra_call = false;
    private $codename = 'd_google_analytics';
    private $route = 'extension/module/d_google_analytics';
    private $sub_versions = array();
    private $store_id = 0;
    private $error = array();

    public function __construct($registry)
    {
        parent::__construct($registry);

        $this->load->language($this->route);
        $this->load->model($this->route);
        $this->load->model('setting/setting');
        $this->load->model('extension/d_opencart_patch/extension');
        $this->load->model('extension/d_opencart_patch/module');
        $this->load->model('extension/d_opencart_patch/url');
        $this->load->model('extension/d_opencart_patch/load');
        $this->load->model('extension/d_opencart_patch/user');

        $this->d_shopunity = (file_exists(DIR_SYSTEM.'library/d_shopunity/extension/d_shopunity.json'));
        $this->d_opencart_patch = (file_exists(DIR_SYSTEM.'library/d_shopunity/extension/d_opencart_patch.json'));
        $this->extension = json_decode(file_get_contents(DIR_SYSTEM.'library/d_shopunity/extension/'.$this->codename.'.json'), true);
        $this->d_twig_manager = (file_exists(DIR_SYSTEM.'library/d_shopunity/extension/d_twig_manager.json'));
    }

    public function index()
    {
        if($this->d_shopunity){
            $this->load->model('extension/d_shopunity/mbooth');
            $this->model_extension_d_shopunity_mbooth->validateDependencies($this->codename);
        }

        if($this->d_twig_manager){
            $this->load->model('extension/module/d_twig_manager');
            if(!$this->model_extension_module_d_twig_manager->isCompatible()){
                $this->model_extension_module_d_twig_manager->installCompatibility();
                $this->session->data['success'] = $this->language->get('success_twig_compatible');
                $this->response->redirect($this->model_extension_module_d_google_analytics->get_extension_link($this->extra_call));
            }
        }

        if (isset($this->request->get['store_id'])) {
            $this->store_id = $this->request->get['store_id'];
        } else {
            $this->store_id = 0;
        }

        // Styles and scripts
        $this->document->addStyle('view/stylesheet/d_bootstrap_extra/bootstrap.css');
        $this->document->addStyle('view/javascript/d_bootstrap_switch/css/bootstrap-switch.css');
        $this->document->addScript('view/javascript/d_bootstrap_switch/js/bootstrap-switch.min.js');

        $url = '';

        $url_params = array();
        $url_params['store_id'] = $this->store_id;

        $url = ((!empty($url_params)) ? '&' : '' ) . http_build_query($url_params);

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            if (isset($this->request->post[$this->codename.'_extra_call'])
            && $this->request->post[$this->codename.'_extra_call'] == true) {
                $this->extra_call = true;
            }

            if(VERSION >= '3.0.0.0'){
                $new_post = array();
                foreach ($this->request->post as $post_key => $post_value) {
                    $new_post['module_'.$post_key] = $post_value;
                    $new_post['analytics_'.$post_key] = $post_value;
                }
                $this->model_setting_setting->editSetting('module_'.$this->codename, $new_post, $this->store_id);
                $this->model_setting_setting->editSetting('analytics_'.$this->codename, $new_post, $this->store_id);
            }

            $this->model_setting_setting->editSetting($this->codename, $this->request->post, $this->store_id);
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->model_extension_module_d_google_analytics->get_extension_link($this->extra_call));
        }

        // Heading
        $this->document->setTitle($this->language->get('heading_title_main'));
        $data['heading_title'] = $this->language->get('heading_title_main');
        $data['heading_title_main'] = $this->language->get('heading_title_main');

        $data['text_yes'] = $this->language->get('text_yes');
        $data['text_no'] = $this->language->get('text_no');
        $data['text_edit'] = $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_signup'] = $this->language->get('text_signup');
        $data['text_analytics'] = $this->language->get('text_analytics');
        $data['text_enable_anal'] = $this->language->get('text_enable_anal');

        $data['entry_code'] = $this->language->get('entry_code');
        $data['entry_status'] = $this->language->get('entry_status');

        $data['help_install_anal'] = $this->language->get('help_install_anal');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        // Notification
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        // Breadcrumbs
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->model_extension_d_opencart_patch_url->link('common/dashboard')
        );

        $data['breadcrumbs'][] = array(
            'text'      => ($this->extra_call) ? $this->language->get('text_analytics') : $this->language->get('text_module'),
            'href'      => $this->model_extension_module_d_google_analytics->get_extension_link($this->extra_call)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title_main'),
            'href' => $this->model_extension_d_opencart_patch_url->link($this->route)
        );

        // Variables
        $data['id'] = $this->codename;
        $data['route'] = $this->route;
        $data['store_id'] = $this->store_id;
        $data['version'] = $this->extension['version'];
        $data['token'] = $this->model_extension_d_opencart_patch_user->getToken();
        $data['extra_call'] = $this->extra_call;
        $data['stores'] = $this->model_extension_module_d_google_analytics->get_stores();

        // Action
        $data['module_link'] = $this->model_extension_d_opencart_patch_url->ajax($this->route);
        $data['action'] = $this->model_extension_d_opencart_patch_url->link($this->route, $url);
        $data['token'] = $this->model_extension_d_opencart_patch_user->getUrlToken();
        $data['cancel'] = $this->model_extension_module_d_google_analytics->get_extension_link($this->extra_call);

        $data['anal_install'] = $this->model_extension_module_d_google_analytics->anal_install_handler();

        if (isset($this->request->post[$this->codename . '_code'])) {
            $data[$this->codename . '_code'] = $this->request->post[$this->codename . '_code'];
        } else {
            $data[$this->codename . '_code'] = $this->model_extension_module_d_google_analytics->get_setting_value($this->codename . '_code', $this->store_id);
        }

        if (isset($this->request->post[$this->codename . '_status'])) {
            $data[$this->codename . '_status'] = $this->request->post[$this->codename . '_status'];
        } else {
            $data[$this->codename . '_status'] = $this->model_extension_module_d_google_analytics->get_setting_value($this->codename . '_status', $this->store_id);
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->model_extension_d_opencart_patch_load->view($this->route, $data));
    }

    private function validate()
    {
        if (!$this->user->hasPermission('modify', $this->route)) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    public function install()
    {
        if ($this->d_shopunity) {
            $this->load->model('extension/d_shopunity/mbooth');
            $this->model_extension_d_shopunity_mbooth->installDependencies($this->codename);
        }

        $this->model_extension_module_d_google_analytics->modification_handler(1);
        $this->model_extension_d_opencart_patch_extension->install('analytics', $this->codename);

        $this->load->model('user/user_group');
        $this->model_user_user_group->addPermission($this->model_extension_d_opencart_patch_user->getGroupId(), 'access', 'extension/analytics/d_google_analytics');
        $this->model_user_user_group->addPermission($this->model_extension_d_opencart_patch_user->getGroupId(), 'modify', 'extension/analytics/d_google_analytics');
    }

    public function uninstall()
    {
        $this->model_extension_module_d_google_analytics->modification_handler(0);
        $this->model_extension_d_opencart_patch_extension->uninstall('analytics', $this->codename);
    }


}
