<?php
class ControllerExtensionModuleDSEOAnalyser extends Controller {
	private $codename = 'd_seo_analyser';
	private $route = 'extension/module/d_seo_analyser';
	private $config_file = 'd_seo_analyser';
	private $extension = array();
	private $error = array(); 
		
	public function __construct($registry) {
		parent::__construct($registry);
		
		$this->d_shopunity = (file_exists(DIR_SYSTEM . 'library/d_shopunity/extension/d_shopunity.json'));
		$this->extension = json_decode(file_get_contents(DIR_SYSTEM . 'library/d_shopunity/extension/' . $this->codename . '.json'), true);
	}
	
	public function index() {		
		$this->setting();
	}
		
	public function setting() {
		$this->load->language($this->route);

		$this->load->model($this->route);
		$this->load->model('setting/setting');
		$this->load->model('localisation/language');
				
		if ($this->d_shopunity) {
			$this->load->model('extension/d_shopunity/mbooth');
				
			$this->model_extension_d_shopunity_mbooth->validateDependencies($this->codename);
		}
		
		if (file_exists(DIR_APPLICATION . 'model/module/d_twig_manager.php')) {
			$this->load->model('module/d_twig_manager');
			
			$this->model_module_d_twig_manager->installCompatibility();
		}
		
		$url_token = '';
		
		if (isset($this->session->data['token'])) {
			$url_token .=  'token=' . $this->session->data['token'];
		}
		
		if (isset($this->session->data['user_token'])) {
			$url_token .=  'user_token=' . $this->session->data['user_token'];
		}

		// Styles and Scripts
		$this->document->addStyle('view/stylesheet/d_bootstrap_extra/bootstrap.css');
		$this->document->addScript('view/javascript/d_bootstrap_switch/js/bootstrap-switch.min.js');
        $this->document->addStyle('view/javascript/d_bootstrap_switch/css/bootstrap-switch.css');
		$this->document->addStyle('view/javascript/summernote/summernote.css');
        $this->document->addScript('view/javascript/summernote/summernote.js');
		$this->document->addScript('view/javascript/summernote/opencart.js');
		$this->document->addStyle('view/stylesheet/' . $this->codename . '.css');

		// Heading
		$this->document->setTitle($this->language->get('heading_title_main'));
		$data['heading_title'] = $this->language->get('heading_title_main');

		// Variable
		$data['codename'] = $this->codename;
		$data['route'] = $this->route;
		$data['version'] = $this->extension['version'];
		$data['config'] = $this->config_file;
		$data['d_shopunity'] = $this->d_shopunity;
		$data['stores'] = $this->{'model_extension_module_' . $this->codename}->getStores();
		$data['languages'] = $this->{'model_extension_module_' . $this->codename}->getLanguages();
		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$data['server'] = HTTPS_SERVER;
			$data['catalog'] = HTTPS_CATALOG;
		} else {
			$data['server'] = HTTP_SERVER;
			$data['catalog'] = HTTP_CATALOG;
		}
		
		// Action
		$data['href_setting'] = $this->url->link($this->route . '/setting', $url_token, true);
		$data['href_history'] = $this->url->link($this->route . '/history', $url_token, true);
		$data['href_instruction'] = $this->url->link($this->route . '/instruction', $url_token, true);
		
		$data['module_link'] = $this->url->link($this->route, $url_token, true);
		$data['action'] = $this->url->link($this->route . '/save', $url_token, true);
			
		if (VERSION >= '3.0.0.0') {
			$data['cancel'] = $this->url->link('marketplace/extension', $url_token . '&type=module', true);
		} elseif (VERSION >= '2.3.0.0') {
			$data['cancel'] = $this->url->link('extension/extension', $url_token . '&type=module', true);
		} else {
			$data['cancel'] = $this->url->link('extension/module', $url_token, true);
		}
		
		// Tab
		$data['text_settings'] = $this->language->get('text_settings');
		$data['text_history'] = $this->language->get('text_history');
		$data['text_instructions'] = $this->language->get('text_instructions');
		$data['text_instructions_full'] = $this->language->get('text_instructions_full');
				
		// Button
		$data['button_save'] = $this->language->get('button_save');
		$data['button_save_and_stay'] = $this->language->get('button_save_and_stay');
		$data['button_cancel'] = $this->language->get('button_cancel');
				
		// Entry
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_list_limit'] = $this->language->get('entry_list_limit');
		$data['entry_description'] = $this->language->get('entry_description');
		
		// Text
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		
		// Notification
		foreach($this->error as $key => $error){
			$data['error'][$key] = $error;
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		// Breadcrumbs
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $url_token, true)
		);
				
		if (VERSION >= '3.0.0.0') {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('marketplace/extension', $url_token . '&type=module', true)
			);
		} elseif (VERSION >= '2.3.0.0') {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('extension/extension', $url_token . '&type=module', true)
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('extension/module', $url_token, true)
			);
		}

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title_main'),
			'href' => $this->url->link($this->route, $url_token, true)
		);

		// Setting 		
		$this->config->load($this->config_file);
		$data['setting'] = ($this->config->get($this->codename . '_setting')) ? $this->config->get($this->codename . '_setting') : array();
		
		$setting = $this->model_setting_setting->getSetting($this->codename);
		$status = isset($setting[$this->codename . '_status']) ? $setting[$this->codename . '_status'] : false;
		$setting = isset($setting[$this->codename . '_setting']) ? $setting[$this->codename . '_setting'] : array();
		
		$data['status'] = $status;
								
		if (!empty($setting)) {
			$data['setting'] = array_replace_recursive($data['setting'], $setting);
		}
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view($this->route . '/setting', $data));
	}
	
	public function history() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
		$this->load->model('setting/setting');
		$this->load->model('localisation/language');
		
		if ($this->d_shopunity) {		
			$this->load->model('extension/d_shopunity/mbooth');
				
			$this->model_extension_d_shopunity_mbooth->validateDependencies($this->codename);
		}
		
		if (file_exists(DIR_APPLICATION . 'model/extension/module/d_twig_manager.php')) {
			$this->load->model('extension/module/d_twig_manager');
			
			$this->model_extension_module_d_twig_manager->installCompatibility();
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'h.history_id';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
						
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url_token = '';
		
		if (isset($this->session->data['token'])) {
			$url_token .= 'token=' . $this->session->data['token'];
		}
		
		if (isset($this->session->data['user_token'])) {
			$url_token .= 'user_token=' . $this->session->data['user_token'];
		}
		
		$url_sort = 'sort=' . $sort;
		$url_order = 'order=' . $order;
		$url_order_inverse = ($order == 'ASC') ? 'order=DESC' : 'order=ASC';		
		$url_page = 'page=' . $page;
						
		// Styles and Scripts
		$this->document->addStyle('view/stylesheet/d_bootstrap_extra/bootstrap.css');
		$this->document->addScript('view/javascript/d_bootstrap_switch/js/bootstrap-switch.min.js');
        $this->document->addStyle('view/javascript/d_bootstrap_switch/css/bootstrap-switch.css');
		$this->document->addScript('view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
		$this->document->addStyle('view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');
		$this->document->addStyle('view/stylesheet/' . $this->codename . '.css');
					
		// Heading
		$this->document->setTitle($this->language->get('heading_title_main'));
		$data['heading_title'] = $this->language->get('heading_title_main');
		
		// Variable
		$data['codename'] = $this->codename;
		$data['route'] = $this->route;
		$data['version'] = $this->extension['version'];
		$data['config'] = $this->config_file;
		$data['d_shopunity'] = $this->d_shopunity;
		$data['sort'] = $sort;
		$data['order'] = $order;
		$data['page'] = $page;
		$data['url_token'] = $url_token;
		$data['stores'] = $this->{'model_extension_module_' . $this->codename}->getStores();
		$data['languages'] = $this->{'model_extension_module_' . $this->codename}->getLanguages();
								
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$data['server'] = HTTPS_SERVER;
			$data['catalog'] = HTTPS_CATALOG;
		} else {
			$data['server'] = HTTP_SERVER;
			$data['catalog'] = HTTP_CATALOG;
		}
						
		// Action
		$data['href_setting'] = $this->url->link($this->route . '/setting', $url_token, true);
		$data['href_history'] = $this->url->link($this->route . '/history', $url_token, true);
		$data['href_instruction'] = $this->url->link($this->route . '/instruction', $url_token, true);
		
		$data['module_link'] = $this->url->link($this->route, $url_token, true);
				
		if (VERSION >= '3.0.0.0') {
			$data['cancel'] = $this->url->link('marketplace/extension', $url_token . '&type=module', true);
		} elseif (VERSION >= '2.3.0.0') {
			$data['cancel'] = $this->url->link('extension/extension', $url_token . '&type=module', true);
		} else {
			$data['cancel'] = $this->url->link('extension/module', $url_token, true);
		}
		
		// Tab
		$data['text_settings'] = $this->language->get('text_settings');
		$data['text_history'] = $this->language->get('text_history');
		$data['text_instructions'] = $this->language->get('text_instructions');
								
		// Button
		$data['button_save'] = $this->language->get('button_save');
		$data['button_save_and_stay'] = $this->language->get('button_save_and_stay');
		$data['button_cancel'] = $this->language->get('button_cancel');	
		$data['button_delete_history'] = $this->language->get('button_delete_history');	
		$data['button_filter'] = $this->language->get('button_filter');
		$data['button_clear_filter'] = $this->language->get('button_clear_filter');
						
		// Column
		$data['column_history_id'] = $this->language->get('column_history_id');
		$data['column_customer_email'] = $this->language->get('column_customer_email');
		$data['column_url'] = $this->language->get('column_url');
		$data['column_method'] = $this->language->get('column_method');
		$data['column_rating'] = $this->language->get('column_rating');
		$data['column_date_added'] = $this->language->get('column_date_added');
		
		// Entry
		$data['entry_history_id'] = $this->language->get('entry_history_id');
		$data['entry_customer_email'] = $this->language->get('entry_customer_email');
		$data['entry_url'] = $this->language->get('entry_url');
		$data['entry_method'] = $this->language->get('entry_method');
		$data['entry_date_added_from'] = $this->language->get('entry_date_added_from');
		$data['entry_date_added_to'] = $this->language->get('entry_date_added_to');
				
		// Text
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_fast'] = $this->language->get('text_fast');
		$data['text_full'] = $this->language->get('text_full');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_delete_history_confirm'] = $this->language->get('text_delete_history_confirm');
				
		// Notification
		foreach ($this->error as $key => $error) {
			$data['error'][$key] = $error;
		}
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}
		
		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}
		
		if (isset($this->request->post['clear_filter'])) {
			if ($this->request->post['clear_filter']) {	
				unset($this->request->post['filter']);
				unset($this->session->data[$this->codename . '_filter']);
			}
		}
		
		if (isset($this->request->post['filter'])) {
			$filter = $this->request->post['filter'];
			$i = 0;
			
			foreach($filter as $value) {
				if ($value) $i++;
			}
			if ($i > 0) {
				$this->session->data[$this->codename . '_filter'] = $filter;
			} else {
				$filter = array();
				unset($this->session->data[$this->codename . '_filter']);
			}
		} elseif (isset($this->session->data[$this->codename . '_filter'])) {
			$filter = $this->session->data[$this->codename . '_filter'];
		} else {
			$filter = array();
			unset($this->session->data[$this->codename . '_filter']);
		}
		
		// Breadcrumbs
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $url_token, true)
		);

		if (VERSION >= '3.0.0.0') {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('marketplace/extension', $url_token . '&type=module', true)
			);
		} elseif (VERSION >= '2.3.0.0') {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('extension/extension', $url_token . '&type=module', true)
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('extension/module', $url_token, true)
			);
		}

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title_main'),
			'href' => $this->url->link($this->route, $url_token, true)
		);
				
		// Setting 	
		$this->config->load($this->config_file);
		$data['setting'] = ($this->config->get($this->codename . '_setting')) ? $this->config->get($this->codename . '_setting') : array();
		
		$setting = $this->model_setting_setting->getSetting($this->codename);
		$setting = isset($setting[$this->codename . '_setting']) ? $setting[$this->codename . '_setting'] : array();
										
		if (!empty($setting)) {
			$data['setting'] = array_replace_recursive($data['setting'], $setting);
		}
		
		$filter_data = array(
			'filter'			=> $filter,
			'sort'  			=> $sort,
			'order' 			=> $order,
			'start' 			=> ($page - 1) * $data['setting']['list_limit'],
			'limit' 			=> $data['setting']['list_limit']
		);
		
		$history_total = $this->{'model_extension_module_' . $this->codename}->getTotalHistories($filter_data);
		
		$data['histories'] = $this->{'model_extension_module_' . $this->codename}->getHistories($filter_data);
				
		$data['sort_history_id'] = $this->url->link($this->route . '/history', $url_token . '&sort=h.history_id' . '&' . $url_order_inverse . '&' . $url_page, true);
		$data['sort_customer_email'] = $this->url->link($this->route . '/history', $url_token . '&sort=c.email' . '&' . $url_order_inverse . '&' . $url_page, true);
		$data['sort_url'] = $this->url->link($this->route . '/history', $url_token . '&sort=u.url' . '&' . $url_order_inverse . '&' . $url_page, true);
		$data['sort_method'] = $this->url->link($this->route . '/history', $url_token . '&sort=h.method' . '&' . $url_order_inverse . '&' . $url_page, true);
		$data['sort_rating'] = $this->url->link($this->route . '/history', $url_token . '&sort=h.rating' . '&' . $url_order_inverse . '&' . $url_page, true);
		$data['sort_date_added'] = $this->url->link($this->route . '/history', $url_token . '&sort=h.date_added' . '&' . $url_order_inverse . '&' . $url_page, true);
		
				
		$pagination = new Pagination();
		$pagination->total = $history_total;
		$pagination->page = $page;
		$pagination->limit = $data['setting']['list_limit'];
		$pagination->url = $this->url->link($this->route . '/history', $url_token . '&' . $url_sort . '&' . $url_order . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($history_total) ? (($page - 1) * $data['setting']['list_limit']) + 1 : 0, ((($page - 1) * $data['setting']['list_limit']) > ($history_total - $data['setting']['list_limit'])) ? $history_total : ((($page - 1) * $data['setting']['list_limit']) + $data['setting']['list_limit']), $history_total, ceil($history_total / $data['setting']['list_limit']));
		
		$data['filter'] = $filter;
								
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view($this->route . '/history', $data));
	}
	
	public function instruction() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
		$this->load->model('setting/setting');
		$this->load->model('localisation/language');
		
		if ($this->d_shopunity) {		
			$this->load->model('extension/d_shopunity/mbooth');
				
			$this->model_extension_d_shopunity_mbooth->validateDependencies($this->codename);
		}
		
		if (file_exists(DIR_APPLICATION . 'model/extension/module/d_twig_manager.php')) {
			$this->load->model('extension/module/d_twig_manager');
			
			$this->model_extension_module_d_twig_manager->installCompatibility();
		}
								
		$url_token = '';
		
		if (isset($this->session->data['token'])) {
			$url_token .= 'token=' . $this->session->data['token'];
		}
		
		if (isset($this->session->data['user_token'])) {
			$url_token .= 'user_token=' . $this->session->data['user_token'];
		}
				
		// Styles and Scripts
		$this->document->addStyle('view/stylesheet/d_bootstrap_extra/bootstrap.css');
		$this->document->addScript('view/javascript/d_bootstrap_switch/js/bootstrap-switch.min.js');
        $this->document->addStyle('view/javascript/d_bootstrap_switch/css/bootstrap-switch.css');
		$this->document->addStyle('view/stylesheet/' . $this->codename . '.css');
				
		// Heading
		$this->document->setTitle($this->language->get('heading_title_main'));
		$data['heading_title'] = $this->language->get('heading_title_main');
		
		// Variable
		$data['codename'] = $this->codename;
		$data['route'] = $this->route;
		$data['version'] = $this->extension['version'];
		$data['config'] = $this->config_file;
		$data['d_shopunity'] = $this->d_shopunity;
								
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$data['server'] = HTTPS_SERVER;
			$data['catalog'] = HTTPS_CATALOG;
		} else {
			$data['server'] = HTTP_SERVER;
			$data['catalog'] = HTTP_CATALOG;
		}
						
		// Action
		$data['href_setting'] = $this->url->link($this->route . '/setting', $url_token, true);
		$data['href_history'] = $this->url->link($this->route . '/history', $url_token, true);
		$data['href_instruction'] = $this->url->link($this->route . '/instruction', $url_token, true);
		
		$data['module_link'] = $this->url->link($this->route, $url_token, true);
				
		if (VERSION >= '3.0.0.0') {
			$data['cancel'] = $this->url->link('marketplace/extension', $url_token . '&type=module', true);
		} elseif (VERSION >= '2.3.0.0') {
			$data['cancel'] = $this->url->link('extension/extension', $url_token . '&type=module', true);
		} else {
			$data['cancel'] = $this->url->link('extension/module', $url_token, true);
		}
		
		// Tab
		$data['text_settings'] = $this->language->get('text_settings');
		$data['text_history'] = $this->language->get('text_history');
		$data['text_instructions'] = $this->language->get('text_instructions');
						
		// Button
		$data['button_cancel'] = $this->language->get('button_cancel');	
												
		// Text
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_instructions_full'] = $this->language->get('text_instructions_full');
				
		// Notification
		foreach ($this->error as $key => $error) {
			$data['error'][$key] = $error;
		}
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}
		
		// Breadcrumbs
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $url_token, true)
		);

		if (VERSION >= '3.0.0.0') {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('marketplace/extension', $url_token . '&type=module', true)
			);
		} elseif (VERSION >= '2.3.0.0') {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('extension/extension', $url_token . '&type=module', true)
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_modules'),
				'href' => $this->url->link('extension/module', $url_token, true)
			);
		}

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title_main'),
			'href' => $this->url->link($this->route, $url_token, true)
		);
								
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view($this->route . '/instruction', $data));
	}
			
	public function save() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting($this->codename, $this->request->post);

			$data['success'] = $this->language->get('success_save');
		}
						
		$data['error'] = $this->error;
				
		$this->response->setOutput(json_encode($data));
	}
	
	public function deleteHistory() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
				
		if (isset($this->request->post['selected']) && $this->validate()) {
			foreach ($this->request->post['selected'] as $history_id) {
				$this->{'model_extension_module_' . $this->codename}->deleteHistory($history_id);
			}
			
			$data['success'] = $this->language->get('success_delete_history');
		}
		
		$data['error'] = $this->error;
				
		$this->response->setOutput(json_encode($data));
	}
		
	public function install() {
		$this->load->model($this->route);

        if ($this->d_shopunity) {
            $this->load->model('extension/d_shopunity/mbooth');

            $this->model_extension_d_shopunity_mbooth->installDependencies($this->codename);
        }

		if (file_exists(DIR_APPLICATION . 'model/module/d_twig_manager.php')) {
			$this->load->model('module/d_twig_manager');
			
			$this->model_module_d_twig_manager->installCompatibility();
		}

		$this->{'model_extension_module_' . $this->codename}->installModule();		
	}
	
	public function uninstall() {
		$this->load->model($this->route);
		
		$this->{'model_extension_module_' . $this->codename}->uninstallModule();		
	}
												
	/*
	*	Validator Functions.
	*/		 	
	private function validate($permission = 'modify') {
		if (isset($this->request->post['config'])) {
			return false;
		}
				
		if (!$this->user->hasPermission($permission, $this->route)) {
			$this->error['warning'] = $this->language->get('error_permission');
			return false;
		}
		
		return true;
	}
}