<?php
class ModelCatalogCiquickcontact extends Model {	
	public function deleteContactRequest($ciquickcontact_id) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "ciquickcontact` WHERE ciquickcontact_id = '" . (int)$ciquickcontact_id . "'");
	}

	public function getContactRequest($ciquickcontact_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "ciquickcontact WHERE ciquickcontact_id = '" . (int)$ciquickcontact_id . "'");
		
		return $query->row;
	}

	public function getContactRequests($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "ciquickcontact WHERE ciquickcontact_id > 0";

		$sort_data = array(
			'contact_name',
			'contact_email',
			'contact_enquiry',
			'ip',
			'reply',
			'date_added',
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY date_added";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	
	public function getTotalContactRequest() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "ciquickcontact");

		return $query->row['total'];
	}

	public function addReply($data) {
		if(!empty($data['ciquickcontact_ids'])) {
			foreach($data['ciquickcontact_ids'] as $ciquickcontact_id) {
				// Add First Reply
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ciquickcontact WHERE ciquickcontact_id = '". (int)$ciquickcontact_id ."' AND reply = 0");

				if($query->row) {
					$this->db->query("UPDATE " . DB_PREFIX . "ciquickcontact SET first_reply_subject = '". $this->db->escape($data['subject']) ."', first_reply_message = '". $this->db->escape($data['message']) ."', first_reply_date = NOW(), reply = '1' WHERE ciquickcontact_id = '". (int)$ciquickcontact_id ."'");
				}

				$ciquickcontact_info = $this->getContactRequest($ciquickcontact_id);
				if($ciquickcontact_info) {
					// Send Email
					$catalog_url = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

					if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
						$logo = $catalog_url . 'image/' . $this->config->get('config_logo');
					} else {
						$logo = '';
					}

					$home_href = $catalog_url;

					$find = array(
						'{STORE_NAME}',
						'{STORE_LINK}',
						'{LOGO}',
						'{NAME}',
						'{EMAIL}',
						'{MESSAGE}',
					);
				
					$replace = array(
						'STORE_NAME'					=> $this->config->get('config_name'),
						'STORE_LINK'					=> $home_href,
						'LOGO'							=> '<img src="'. $logo .'" alt="'. $this->config->get('config_name') .'" title="'. $this->config->get('config_name') .'" />',
						'NAME'					=> $ciquickcontact_info['contact_name'],
						'EMAIL'					=> $ciquickcontact_info['contact_email'],
						'MESSAGE'				=> nl2br(strip_tags($ciquickcontact_info['contact_enquiry'])),
					);
					
					$subject = $data['subject'];
					$message = $data['message'];

					if(!empty($subject)) {
						$subject = str_replace($find, $replace, $subject);
					}else{
						$subject = '';
					}
					
					if(!empty($message)) {
						$message = str_replace($find, $replace, $message);
					}else{
						$message = '';
					}
					
					$mail = new Mail($this->config->get('config_mail_engine'));
					$mail->parameter = $this->config->get('config_mail_parameter');
					$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
					$mail->smtp_username = $this->config->get('config_mail_smtp_username');
					$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
					$mail->smtp_port = $this->config->get('config_mail_smtp_port');
					$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

					$mail->setTo($ciquickcontact_info['contact_email']);
					$mail->setFrom($this->config->get('config_email'));
					$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
					$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
					$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
					$mail->send();
				}
			}
		}
	}
}