<?php
/*
 *  location: admin/model
 */
class ModelExtensionModuleDGoogleAnalytics extends Model {

    private $codename = 'd_google_analytics';

    public function __construct($registry)
    {
        parent::__construct($registry);

        $this->load->model('extension/d_opencart_patch/url');
        $this->load->model('extension/d_opencart_patch/modification');
    }

    public function anal_install_handler()
    {
        $is_installed = $this->is_extension_installed($this->codename, 'analytics');

        return array(
            'status' => $is_installed,
            'link'   => ($is_installed) ? $this->get_anal_link('uninstall') : $this->get_anal_link('install')
        );
    }

    public function get_anal_link($status)
    {
        if (VERSION > '2.3.0.0') {
            return $this->model_extension_d_opencart_patch_url->ajax('extension/extension/analytics/'.$status, '&extension='.$this->codename);
        } elseif ( (VERSION > '2.1.0.0') && (VERSION < '2.3.0.0') ) {
            return $this->model_extension_d_opencart_patch_url->ajax('extension/analytics/'.$status, '&extension='.$this->codename);
        }
    }

    private function is_extension_installed($code, $type = false)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "extension WHERE ";

        if($type){
            $sql .= "`type` = '" . $this->db->escape($type) . "' AND ";
        }

        $sql .= "`code` = '" . $this->db->escape($code) . "'";

        $query = $this->db->query($sql);
        if(!empty($query->row)){
            return true;
        }
        return false;
    }

    public function get_extension_link($extra_call)
    {
        if ($extra_call) {
            return $this->model_extension_d_opencart_patch_url->getExtensionLink('analytics');
        } else {
            return $this->model_extension_d_opencart_patch_url->getExtensionLink('module');
        }
    }

    public function get_stores()
    {
        $this->load->model('setting/store');
        $stores = $this->model_setting_store->getStores();
        $result = array();
        if($stores){
            $result[] = array(
                'store_id' => 0,
                'name' => $this->config->get('config_name')
                );
            foreach ($stores as $store) {
                $result[] = array(
                    'store_id' => $store['store_id'],
                    'name' => $store['name']
                    );
            }
        }
        return $result;
    }

    public function get_setting_value($key, $store_id = 0) {
        $query = $this->db->query("SELECT value FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `key` = '" . $this->db->escape($key) . "'");

        if ($query->num_rows) {
            return $query->row['value'];
        } else {
            return null;
        }
    }

    public function modification_handler($status)
    {
        $this->model_extension_d_opencart_patch_modification->setModification('d_google_analytics.xml', $status);
        $this->model_extension_d_opencart_patch_modification->refreshCache();
    }

}