<?php
class ModelExtensionModuleDSEOAnalyser extends Model {
	private $codename = 'd_seo_analyser';
	
	/*
	*	Return Histories.
	*/
	public function getHistories($data = array()) {		
		$sql = "SELECT h.history_id, c.email as customer_email, u.url, h.method, h.rating, h.date_added FROM " . DB_PREFIX . "d_seo_analyser_history h LEFT JOIN " . DB_PREFIX . "d_seo_analyser_customer c ON (c.customer_id = h.customer_id) LEFT JOIN " . DB_PREFIX . "d_seo_analyser_url u ON (u.url_id = h.url_id)";
				
		$implode = array();
		
		if (isset($data['filter'])) {
			foreach ($data['filter'] as $field_code => $filter) {
				if (!empty($filter)) {
					if ($field_code == 'history_id') {
						$implode[] = "h.history_id = '" . $this->db->escape($filter) . "'";
					}
					
					if ($field_code == 'customer_email') {
						$implode[] = "c.email LIKE '%" . $this->db->escape($filter) . "%'";
					}
					
					if ($field_code == 'url') {
						$implode[] = "u.url LIKE '%" . $this->db->escape($filter) . "%'";
					}
					
					if ($field_code == 'method') {
						$implode[] = "h.method = '" . $this->db->escape($filter) . "'";
					}
					
					if ($field_code == 'date_added_from') {
						$implode[] = "DATE(h.date_added) > DATE('" . $this->db->escape($filter) . "')";
					}
		
					if ($field_code == 'date_added_to') {
						$implode[] = "DATE(h.date_added) < DATE('" . $this->db->escape($filter) . "')";
					}
				}
			}
		}
		
		if ($implode) {
			$sql .= " WHERE " .  implode(' AND ', $implode);
		}
		
		if (isset($data['sort'])) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY h.history_id";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
								
		return $query->rows;
	}
	
	/*
	*	Delete History.
	*/
	public function deleteHistory($history_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "d_seo_analyser_history WHERE history_id = '" . (int)$history_id . "'");
	}
	
	/*
	*	Return Total Histories.
	*/
	public function getTotalHistories($data = array()) {		
		$sql = "SELECT COUNT(DISTINCT history_id) AS total FROM " . DB_PREFIX . "d_seo_analyser_history h LEFT JOIN " . DB_PREFIX . "d_seo_analyser_customer c ON (c.customer_id = h.customer_id) LEFT JOIN " . DB_PREFIX . "d_seo_analyser_url u ON (u.url_id = h.url_id)";

		$implode = array();
		
		if (isset($data['filter'])) {
			foreach ($data['filter'] as $field_code => $filter) {
				if (!empty($filter)) {
					if ($field_code == 'history_id') {
						$implode[] = "h.history_id = '" . $this->db->escape($filter) . "'";
					}
					
					if ($field_code == 'customer_email') {
						$implode[] = "c.email LIKE '%" . $this->db->escape($filter) . "%'";
					}
					
					if ($field_code == 'url') {
						$implode[] = "u.url LIKE '%" . $this->db->escape($filter) . "%'";
					}
					
					if ($field_code == 'method') {
						$implode[] = "h.method = '" . $this->db->escape($filter) . "'";
					}
					
					if ($field_code == 'date_added_from') {
						$implode[] = "DATE(h.date_added) > DATE('" . $this->db->escape($filter) . "')";
					}
		
					if ($field_code == 'date_added_to') {
						$implode[] = "DATE(h.date_added) < DATE('" . $this->db->escape($filter) . "')";
					}
				}
			}
		}
		
		if ($implode) {
			$sql .= " WHERE " .  implode(' AND ', $implode);
		}

		$query = $this->db->query($sql);
								
		return $query->row['total'];
	}
	
	/*
	*	Return list of languages.
	*/
	public function getLanguages() {
		$this->load->model('localisation/language');
		
		$languages = $this->model_localisation_language->getLanguages();
		
		foreach ($languages as $key => $language) {
            $languages[$key]['flag'] = 'language/' . $language['code'] . '/' . $language['code'] . '.png';
        }
		
		return $languages;
	}
	
	/*
	*	Return list of stores.
	*/
	public function getStores() {
		$this->load->model('setting/store');
		
		$result = array();
		
		$stores = $this->model_setting_store->getStores();
		
		if ($stores) {
			$result[] = array(
				'store_id' => 0, 
				'name' => $this->config->get('config_name')
			);
			
			foreach ($stores as $store) {
				$result[] = array(
					'store_id' => $store['store_id'],
					'name' => $store['name']	
				);
			}	
		}
		
		return $result;
	}
	
	/*
	*	Install.
	*/		
	public function installModule() {		
		$this->db->query("CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "d_seo_analyser_customer (customer_id INT(11) NOT NULL AUTO_INCREMENT, email VARCHAR(96) NOT NULL, PRIMARY KEY (customer_id)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
		$this->db->query("CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "d_seo_analyser_url (url_id INT(11) NOT NULL AUTO_INCREMENT, url VARCHAR(255) NOT NULL, PRIMARY KEY (url_id)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
		$this->db->query("CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "d_seo_analyser_url_to_customer (url_id INT(11) NOT NULL, customer_id INT(11) NOT NULL, PRIMARY KEY (url_id, customer_id)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
		$this->db->query("CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "d_seo_analyser_history (history_id INT(11) NOT NULL AUTO_INCREMENT, customer_id INT(11) NOT NULL, url_id INT(11) NOT NULL, method VARCHAR(4) NOT NULL, rating INT(11) NOT NULL, date_added DATETIME NOT NULL, PRIMARY KEY (history_id)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
	}
	
	/*
	*	Uninstall.
	*/		
	public function uninstallModule() {		
		$this->db->query("DROP TABLE IF EXISTS " . DB_PREFIX . "d_seo_analyser_customer");
		$this->db->query("DROP TABLE IF EXISTS " . DB_PREFIX . "d_seo_analyser_url");
		$this->db->query("DROP TABLE IF EXISTS " . DB_PREFIX . "d_seo_analyser_url_to_customer");
		$this->db->query("DROP TABLE IF EXISTS " . DB_PREFIX . "d_seo_analyser_history");
	}
}
?>