<?php
class ControllerExtensionAnalyticsDGoogleAnalytics extends Controller {

    private $codename = 'd_google_analytics';
    private $route = 'extension/analytics/d_google_analytics';

    public function __construct($registry)
    {
        parent::__construct($registry);
        $this->status = ($this->config->get($this->codename . '_status')) ? $this->config->get($this->codename . '_status') : 0;
    }

    public function index()
    {
        if (!$this->status) {
            return;
        }

        $html = $this->config->get('d_google_analytics_code');
        $data_layer = $this->get_data_layer();
        $html = str_replace('[data_layer]', $data_layer, $html);

        return html_entity_decode($html, ENT_QUOTES, 'UTF-8');
    }

    private function get_setting()
    {
        $setting = array();

        if (isset($this->session->data['order_id'])
        && $this->session->data['order_id']
        && isset($this->session->data['shipping_method'])) {

            $setting['order_id'] = $this->session->data['order_id'];
            $setting['shipping'] = $this->session->data['shipping_method'];
            $setting['sub_total'] = $this->cart->getSubTotal();
            $setting['total'] = $this->cart->getTotal();
            $setting['cart']['products'] = $this->cart->getProducts();
        }

        if (isset($this->session->data[$this->codename])) {
            $setting = $this->session->data[$this->codename];
            unset($this->session->data[$this->codename]);
        }

        return $setting;
    }

    private function get_data_layer()
    {
        $this->load->model('checkout/order');
        $this->load->model('catalog/product');
        $this->load->model('catalog/category');

        $data_layer = '';

        $setting = $this->get_setting();

        if (isset($setting['order_id'])&& $setting['order_id']) {

            $order_info = $this->model_checkout_order->getOrder($setting['order_id']);
            if ($order_info) {
                $data['order_id'] = $order_info['order_id'];
                $data['store_name'] = $this->config->get('config_name');
                $data['store_url'] = $this->request->server['SERVER_NAME'];
                $data['currency'] = $this->config->get('config_currency');
                $data['total'] = $this->currency->format($order_info['total'], $data['currency'], '', false);

                if (isset($setting['shipping'])) {
                    $data['shipping']['name'] = $setting['shipping']['title'];
                    $data['shipping']['price'] = $this->currency->format($setting['shipping']['cost'], $data['currency'], '', false);
                    $data['shipping']['tax_price'] = $this->currency->format($this->tax->calculate($setting['shipping']['cost'], $setting['shipping']['tax_class_id'], $this->config->get('config_tax')), $data['currency'], '', false);
                } else {
                    $data['shipping']['name'] = '';
                    $data['shipping']['price'] = 0;
                    $data['shipping']['tax_price'] = 0;
                }

                $data['taxes'] = $this->currency->format($setting['total'] - $setting['sub_total'] + $data['shipping']['tax_price'] - $data['shipping']['price'], $data['currency'], '', false);

                $data['products'] = array();

                $products = $setting['cart']['products'];

                foreach ($products as $product) {

                    $categories = $this->model_catalog_product->getCategories($product['product_id']);
                    if ($categories) {
                        $last = end($categories);
                        $category = $this->model_catalog_category->getCategory($last['category_id']);
                        $category_name = $category['name'];
                    } else {
                        $category_name = '';
                    }

                    $data['products'][] = array(
                        'id' => $product['product_id'],
                        'model' => $product['model'],
                        'quantity' => $product['quantity'],
                        'name' => $product['name'],
                        'category_name' => $category_name,
                        'price' => $this->currency->format($product['price'], $data['currency'], '', false),
                        'tax_price' => $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')), $data['currency'], '', false)
                    );
                }

                $data_layer = $this->load->view($this->route, $data);
            }
        }

        return $data_layer;
    }

    public function update() {
        $html = $this->load->controller($this->route);
        $this->response->setOutput($html);
    }

}