<?php

class ControllerExtensionFeedDGoogleSitemap extends Controller
{
    private $codename = 'd_google_sitemap';
    private $config_file = 'd_google_sitemap';
    private $prefix = '';

    public function __construct($registry)
    {
        parent::__construct($registry);

        $this->prefix = (VERSION > '3.0.0.0') ? 'feed_' : '';
    }

    public function index()
    {
        $this->load->model('setting/setting');
		$this->load->model('localisation/language');
		$this->load->model('localisation/country');
		
		if (isset($this->request->get['language'])) {
            $this->session->data['language'] = $this->request->get['language'];
            $this->response->redirect($this->url->link('extension/feed/d_google_sitemap'));
        }
		
        $languages = $this->model_localisation_language->getLanguages();
		$country = $this->{'model_localisation_country'}->getCountry($this->config->get('config_country_id'));
		
		$config_language_id = $this->config->get('config_language_id');
				
        // Setting
        $this->config->load($this->config_file);
        $config_setting = ($this->config->get($this->codename)) ? $this->config->get($this->codename) : array();

        $setting = $this->model_setting_setting->getSetting($this->prefix . $this->codename);
        $status = isset($setting[$this->prefix . $this->codename . '_status']) ? $setting[$this->prefix . $this->codename . '_status'] : false;
        $setting = isset($setting[$this->prefix . $this->codename . '_setting']) ? $setting[$this->prefix . $this->codename . '_setting'] : array();

        if (!empty($setting)) {
            $config_setting = array_replace_recursive($config_setting, $setting);
        }

        $setting = $config_setting;

        if ($status) {			
			ini_set('max_execution_time', 100);
			
			$output = '';
			
			// Register Cache
			if (!$this->registry->has('d_cache') && file_exists(DIR_SYSTEM . 'library/d_cache.php')) {
				$this->registry->set('d_cache', new d_cache());
			}
						
			if ($this->registry->has('d_cache')) {
				$output = $this->d_cache->get($this->codename, 'sitemap');
			}
						
			if (!$output) {
				$output = '<?xml version="1.0" encoding="UTF-8"?>';
				/*$output = '<?xml-stylesheet type="text/xsl" href="./sitemap.xsl"?>';*/
				$output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';
            			
				if ($setting['page']['home']['status']) {
					$url = array();
						
					foreach ($languages as $language) {
						$this->config->set('config_language_id', $language['language_id']);
						
						$url[$language['language_id']] = $this->url->link('common/home', '', 'SSL');
					}
					
					foreach ($languages as $location_language) {				
						$output .= '<url>';
						$output .= '<loc>' . $url[$location_language['language_id']] . '</loc>';
				
						foreach ($languages as $alternate_language) {
							//$output .= '<xhtml:link rel="alternate" hreflang="' . preg_replace('/-(.+?)+/', '', $alternate_language['code']) . '-' . $country['iso_code_2'] . '" href="' . $url[$alternate_language['language_id']] . '" />';
						}
					
						$output .= '<changefreq>' . $setting['page']['home']['changefreq'] . '</changefreq>';
						$output .= '<priority>' . $setting['page']['home']['priority'] . '</priority>';
						$output .= '</url>';
					}
				}

				if ($setting['page']['product']['status']) {
					$this->load->model('catalog/product');
					$this->load->model('tool/image');

					$products = $this->model_catalog_product->getProducts();

					if (VERSION >= '3.0.0.0') {
						$width = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_width');
						$height = $this->config->get('theme_' . $this->config->get('config_theme') . '_image_product_height');
					} elseif (VERSION >= '2.2.0.0') {
						$width = $this->config->get($this->config->get('config_theme') . '_image_product_width');
						$height = $this->config->get($this->config->get('config_theme') . '_image_product_height');
					} else {
						$width = $this->config->get('config_image_product_width');
						$height = $this->config->get('config_image_product_height');
					}

					foreach ($products as $product) {
						if ($product['image']) {
							$image = $this->model_tool_image->resize($product['image'], $width, $height);
						} else {
							$image = '';
						}
						
						$url = array();
						
						foreach ($languages as $language) {
							$this->config->set('config_language_id', $language['language_id']);
						
							$url[$language['language_id']] = htmlspecialchars(html_entity_decode($this->url->link('product/product', 'product_id=' . $product['product_id']), ENT_QUOTES | ENT_XML1, 'UTF-8'));
						}
					
						foreach ($languages as $location_language) {				
							$output .= '<url>';
							$output .= '<loc>' . $url[$location_language['language_id']] . '</loc>';
					
							foreach ($languages as $alternate_language) {
								//$output .= '<xhtml:link rel="alternate" hreflang="' . preg_replace('/-(.+?)+/', '', $alternate_language['code']) . '-' . $country['iso_code_2'] . '" href="' . $url[$alternate_language['language_id']] . '" />';
							}
					
							$output .= '<changefreq>' . $setting['page']['product']['changefreq'] . '</changefreq>';
							$output .= '<priority>' . $setting['page']['product']['priority'] . '</priority>';
                    
							if ($image) {
								$output .= '<image:image>';
								$output .= '<image:loc>' . $image . '</image:loc>';
								$output .= '<image:caption>' . $product['name'] . '</image:caption>';
								$output .= '<image:title>' . $product['name'] . '</image:title>';
								$output .= '</image:image>';
							}
					
						$output .= '</url>';
						}
					}
				}
			
				if ($setting['page']['category']['status']) {
					$this->load->model('catalog/category');

					$output .= $this->getCategories($setting, 0);
				}

				if ($setting['page']['blog_article']['status']) {
					$this->load->model('extension/d_blog_module/post');

					$articles = $this->model_extension_d_blog_module_post->getPosts();

					foreach ($articles as $article) {
						$url = array();
						
						foreach ($languages as $language) {
							$this->config->set('config_language_id', $language['language_id']);
						
							$url[$language['language_id']] = $this->url->link('extension/d_blog_module/post', 'post_id=' . $article['post_id'], 'SSL');
						}
						
						foreach ($languages as $location_language) {
							$output .= '<url>';
							$output .= '<loc>' . $url[$location_language['language_id']] . '</loc>';
						
							foreach ($languages as $alternate_language) {			
								//$output .= '<xhtml:link rel="alternate" hreflang="' . preg_replace('/-(.+?)+/', '', $alternate_language['code']) . '-' . $country['iso_code_2'] . '" href="' . $url[$alternate_language['language_id']] . '" />';
							}
						
							$output .= '<changefreq>' . $setting['page']['blog_article']['changefreq'] . '</changefreq>';
							$output .= '<priority>' . $setting['page']['blog_article']['priority'] . '</priority>';
							$output .= '</url>';
						}
					}
				}

				if ($setting['page']['blog_category']['status']) {
					$this->load->model('extension/d_blog_module/category');

					$output .= $this->getBlogCategories($setting, 0);
				}

				if ($setting['page']['manufacturer']['status']) {
					$this->load->model('catalog/manufacturer');

					$manufacturers = $this->model_catalog_manufacturer->getManufacturers();

					foreach ($manufacturers as $manufacturer) {
						$url = array();
						
						foreach ($languages as $language) {
							$this->config->set('config_language_id', $language['language_id']);
						
							$url[$language['language_id']] = $this->url->link('product/manufacturer/info', 'manufacturer_id=' . $manufacturer['manufacturer_id'], 'SSL');
						}
						
						foreach ($languages as $location_language) {
							$output .= '<url>';
							$output .= '<loc>' . $url[$location_language['language_id']] . '</loc>';
						
							foreach ($languages as $alternate_language) {				
								//$output .= '<xhtml:link rel="alternate" hreflang="' . preg_replace('/-(.+?)+/', '', $alternate_language['code']) . '-' . $country['iso_code_2'] . '" href="' . $url[$alternate_language['language_id']] . '" />';
							}
                    
							$output .= '<changefreq>' . $setting['page']['manufacturer']['changefreq'] . '</changefreq>';
							$output .= '<priority>' . $setting['page']['manufacturer']['priority'] . '</priority>';
							$output .= '</url>';
						}
					}
				}

				if ($setting['page']['information']['status']) {
					$this->load->model('catalog/information');

					$informations = $this->model_catalog_information->getInformations();

					foreach ($informations as $information) {
						$url = array();
						
						foreach ($languages as $language) {
							$this->config->set('config_language_id', $language['language_id']);
						
							$url[$language['language_id']] = $this->url->link('information/information', 'information_id=' . $information['information_id'], 'SSL');
						}
						
						foreach ($languages as $location_language) {
							$output .= '<url>';
							$output .= '<loc>' . $url[$location_language['language_id']] . '</loc>';
						
							foreach ($languages as $alternate_language) {				
								//$output .= '<xhtml:link rel="alternate" hreflang="' . preg_replace('/-(.+?)+/', '', $alternate_language['code']) . '-' . $country['iso_code_2'] . '" href="' . $url[$alternate_language['language_id']] . '" />';
							}
						
							$output .= '<changefreq>' . $setting['page']['information']['changefreq'] . '</changefreq>';
							$output .= '<priority>' . $setting['page']['information']['priority'] . '</priority>';
							$output .= '</url>';
						}
					}
				}

				$output .= '</urlset>';
			
				$this->config->set('config_language_id', $config_language_id);
				
				if ($this->registry->has('d_cache')) {
					$this->d_cache->set($this->codename, 'sitemap', $output, $setting['expire_time']);
				}
			}

            $this->response->addHeader('Content-Type: application/xml');	
            $this->response->setOutput($output);
        }
    }
	
	public function refresh() {
		$this->load->language($this->route);
		
		// Register Cache
		if (!$this->registry->has('d_cache') && file_exists(DIR_SYSTEM . 'library/d_cache.php')) {
			$this->registry->set('d_cache', new d_cache());
		}
						
		if ($this->registry->has('d_cache')) {
			$this->d_cache->delete($this->codename, 'sitemap');
		}
		
		$this->index();
	}
	
    protected function getCategories($setting, $parent_id, $current_path = '')
    {
        $output = '';

        $results = $this->model_catalog_category->getCategories($parent_id);
		
		$languages = $this->model_localisation_language->getLanguages();
		$country = $this->{'model_localisation_country'}->getCountry($this->config->get('config_country_id'));

        foreach ($results as $result) {
            if (!$current_path) {
                $new_path = $result['category_id'];
            } else {
                $new_path = $current_path . '_' . $result['category_id'];
            }
			
			$url = array();
						
			foreach ($languages as $language) {
				$this->config->set('config_language_id', $language['language_id']);
						
				$url[$language['language_id']] = $this->url->link('product/category', 'path=' . $new_path, 'SSL');
			}

            foreach ($languages as $location_language) {
				$output .= '<url>';
				$output .= '<loc>' . $url[$location_language['language_id']] . '</loc>';
				
				foreach ($languages as $alternate_language) {							
					//$output .= '<xhtml:link rel="alternate" hreflang="' . preg_replace('/-(.+?)+/', '', $alternate_language['code']) . '-' . $country['iso_code_2'] . '" href="' . $url[$alternate_language['language_id']] . '" />';
				}
				
				$output .= '<changefreq>' . $setting['page']['category']['changefreq'] . '</changefreq>';
				$output .= '<priority>' . $setting['page']['category']['priority'] . '</priority>';
				$output .= '</url>';
			}

            $output .= $this->getCategories($setting, $result['category_id'], $new_path);
        }

        return $output;
    }

    protected function getBlogCategories($setting, $parent_id, $current_path = '')
    {
        $output = '';

        $results = $this->model_extension_d_blog_module_category->getCategories($parent_id);
		
		$languages = $this->model_localisation_language->getLanguages();
		$country = $this->{'model_localisation_country'}->getCountry($this->config->get('config_country_id'));

        foreach ($results as $result) {
            if (!$current_path) {
                $new_path = $result['category_id'];
            } else {
                $new_path = $current_path . '_' . $result['category_id'];
            }
			
			$url = array();
						
			foreach ($languages as $language) {
				$this->config->set('config_language_id', $language['language_id']);
						
				$url[$language['language_id']] = $this->url->link('extension/d_blog_module/category', 'category_id=' . $new_path, 'SSL');
			}

            foreach ($languages as $location_language) {				
				$output .= '<url>';
				$output .= '<loc>' . $url[$location_language['language_id']] . '</loc>';
            
				foreach ($languages as $alternate_language) {							
					//$output .= '<xhtml:link rel="alternate" hreflang="' . preg_replace('/-(.+?)+/', '', $alternate_language['code']) . '-' . $country['iso_code_2'] . '" href="' . $url[$alternate_language['language_id']] . '" />';
				}
				
				$output .= '<changefreq>' . $setting['page']['blog_category']['changefreq'] . '</changefreq>';
				$output .= '<priority>' . $setting['page']['blog_category']['priority'] . '</priority>';
				$output .= '</url>';
			}

            $output .= $this->getBlogCategories($setting, $result['category_id'], $new_path);
        }

        return $output;
    }
}
