<?php
class ControllerExtensionModuleAVAutoImageAttribute extends Controller {
	public function index(&$route = '', &$data = array(), &$output = '') {

		$setting = $this->config->get('module_avautoimageattribute');

		if($this->config->get('module_avautoimageattribute_status') == true) {

			$this->load->model('catalog/product');

			if (isset($this->request->get['product_id'])) {
				$product_id = (int)$this->request->get['product_id'];
			} else {
				$product_id = 0;
			}

			$product_info = $this->model_catalog_product->getProduct($product_id);

			$av_ID = $product_info['product_id'];
			$av_Title = $product_info['name'];
			$av_Model = $product_info['model'];
			
			$this->load->model('catalog/category');

			$product_cat = $this->model_catalog_product->getCategories($av_ID);

			if( isset( $product_cat[0]['category_id']) ) {
				$product_cat_parent = $this->model_catalog_category->getCategory($product_cat[0]['category_id']);
				$av_Category = $product_cat_parent['name'];
			} else
				$av_Category = '';

			
			$av_MetaTitle = $product_info['meta_title'];
			$av_Quantity = $product_info['quantity'];
			$av_Manufacturer = $product_info['manufacturer'];
			$av_StockStatus = $product_info['stock_status'];
			$av_date_added = strtotime($product_info['date_added']);
			
			$parameters = explode(' ', $setting['alt_template']);

			$retString = '';
			foreach($parameters as $parameter) {
				switch($parameter) {
					case '[ID]':
						$retString .= $av_ID.' ';
					break;
					case '[Title]':
						$retString .= $av_Title.' ';
					break;
					case '[Model]':
						$retString .= $av_Model.' ';
					break;
					case '[Category]':
						$retString .= $av_Category.' ';
					break;
					case '[MetaTitle]':
						$retString .= $av_MetaTitle.' ';
					break;
					case '[Quantity]':
						$retString .= $av_Quantity.' ';
					break;
					case '[Manufacturer]':
						$retString .= $av_Manufacturer.' ';
					break;
					case '[StockStatus]':
						$retString .= $av_StockStatus.' ';
					break;
					case '[Year]':
						$av_Year = date("Y", $av_date_added);
						$retString .= $av_Year.' ';
					break;
					case '[Month]':
						$av_Month = date("m", $av_date_added);
						$retString .= $av_Month.' ';
					break;
					case '[Day]':
						$av_Day = date("d", $av_date_added);
						$retString .= $av_Day.' ';
					break;
					case '[Hour]':
						$av_Hour = date("h", $av_date_added);
						$retString .= $av_Hour.' ';
					break;
					case '[Minute]':
						$av_Minute = date("i", $av_date_added);
						$retString .= $av_Minute.' ';
					break;
					case '[Second]':
						$av_Second = date("s", $av_date_added);
						$retString .= $av_Second.' ';
					break;
					default:
						$retString .= $parameter.' ';
					break;
				}
			}
			$retString = preg_replace('|[\s]+|s', ' ', mb_strtolower($retString, 'UTF-8'));

if($retString == " ")
	$retString = $av_Title;

			preg_match_all('/<img[^>]+src="?\'?([^"\']+)"?\'?[^>]*>/i', $output, $images, PREG_SET_ORDER);
			
			if($setting['attr_num'] == true) {
				$i = 1;
				foreach ($images as $src) {
					if($src[1] == isset($data['thumb']) || $src[1] == $data['images'][$i]['thumb']) {
						$var = preg_replace('~alt="[^"]*"~i', 'alt="'.$retString.$i++.'"', $src[0]);
						$output = str_replace($src[0], $var, $output);
					}
				}
			}
			else {
				foreach ($images as $src) {
					$i = 1;
					if($src[1] == isset($data['thumb']) || $src[1] == $data['images'][$i]['thumb']) {
						$var = preg_replace('~alt="[^"]*"~i', 'alt="'.rtrim($retString).'"', $src[0]);
						$output = str_replace($src[0], $var, $output);
					}
				}
			}

		}
	}

}