<?php
class ControllerExtensionModuleDSEOAnalyser extends Controller {
	private $codename = 'd_seo_analyser';
	private $route = 'extension/module/d_seo_analyser';
	private $config_file = 'd_seo_analyser';
	private $error = array();
	
	public function index() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
		$this->load->model('setting/setting');
		
		// Setting
		$this->config->load($this->config_file);
		$config_setting = ($this->config->get($this->codename . '_setting')) ? $this->config->get($this->codename . '_setting') : array();
		
		$setting = $this->model_setting_setting->getSetting($this->codename);
		$status = isset($setting[$this->codename . '_status']) ? $setting[$this->codename . '_status'] : false;
		$setting = isset($setting[$this->codename . '_setting']) ? $setting[$this->codename . '_setting'] : array();
		
		if (!empty($setting)) {
			$config_setting = array_replace_recursive($config_setting, $setting);
		}
		
		$setting = $config_setting;
								
		if ($status) {
			// Action
			$data['action'] = $this->url->link($this->route . '/analyse', '', true);
			
			// Text
			$data['text_title'] = $this->language->get('text_title');
			$data['text_description'] = $this->language->get('text_description');
									
			// Entry
			$data['entry_url'] = $this->language->get('entry_url');
			$data['entry_email'] = $this->language->get('entry_email');
			
			// Button
			$data['button_analyse'] = $this->language->get('button_analyse');
			$data['button_processing'] = $this->language->get('button_processing');
			$data['button_fast'] = $this->language->get('button_fast');
			$data['button_full'] = $this->language->get('button_full');
			$data['button_send'] = $this->language->get('button_send');
						
			$data['description'] = isset($setting['description'][$this->config->get('config_language_id')]) ? $setting['description'][$this->config->get('config_language_id')] : '';
			
			if (VERSION >= '2.2.0.0') {
				$theme = $this->config->get($this->config->get('config_theme') . '_directory');
					
				if (file_exists(DIR_TEMPLATE . $theme . '/stylesheet/' . $this->codename . '.css')) {
					$this->document->addStyle('catalog/view/theme/' . $theme . '/stylesheet/' . $this->codename . '.css');
				} else {
					$this->document->addStyle('catalog/view/theme/default/stylesheet/' . $this->codename . '.css');
				}
					
				if (file_exists(DIR_TEMPLATE . $theme . '/javascript/' . $this->codename . '.js')) {
					$this->document->addScript('catalog/view/theme/' . $theme . '/javascript/' . $this->codename . '.js');
				} else {
					$this->document->addScript('catalog/view/theme/default/javascript/' . $this->codename . '.js');
				}
				
				$this->document->addScript('catalog/view/theme/default/javascript/' . $this->codename . '/chart.js');
					
				return $this->load->view($this->route, $data);
			} else {
				if (file_exists('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/' . $this->codename . '.css')) {
					$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_template') . '/stylesheet/' . $this->codename . '.css');
				} else {
					$this->document->addStyle('catalog/view/theme/default/stylesheet/' . $this->codename . '.css');
				}
					
				if (file_exists('catalog/view/theme/' . $this->config->get('config_template') . '/javascript/' . $this->codename . '.js')) {
					$this->document->addScript('catalog/view/theme/' . $this->config->get('config_template') . '/javascript/' . $this->codename . '.js');
				} else {
					$this->document->addScript('catalog/view/theme/default/javascript/' . $this->codename . '.js');
				}
				
				$this->document->addScript('catalog/view/theme/default/javascript/' . $this->codename . '/chart.js');
					
				if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/' . $this->route . '.twig')) {
					return $this->load->view($this->config->get('config_template') . '/template/' . $this->route, $data);
				} else {
					return $this->load->view('default/template/' . $this->route, $data);
				}
			}
		}
	}	

	public function analyse() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
		$this->load->model('setting/setting');
				
		// Setting
		$this->config->load($this->config_file);
		$config_setting = ($this->config->get($this->codename . '_setting')) ? $this->config->get($this->codename . '_setting') : array();
		
		$setting = $this->model_setting_setting->getSetting($this->codename);
		$status = isset($setting[$this->codename . '_status']) ? $setting[$this->codename . '_status'] : false;
		$setting = isset($setting[$this->codename . '_setting']) ? $setting[$this->codename . '_setting'] : array();
		
		if (!empty($setting)) {
			$config_setting = array_replace_recursive($config_setting, $setting);
		}
		
		$setting = $config_setting;
								
		if ($status && $this->validateURL()) {	
			$url = $this->request->get['url'];
											
			// Text		
			$data['text_rating'] = $this->language->get('text_rating');				
			$data['text_total_pages'] = $this->language->get('text_total_pages');
			$data['text_critical'] = $this->language->get('text_critical');
			$data['text_warning'] = $this->language->get('text_warning');
			$data['text_valid'] = $this->language->get('text_valid');
			$data['text_errors'] = $this->language->get('text_errors');
			$data['text_time'] = $this->language->get('text_time');
			$data['text_keywords'] = $this->language->get('text_keywords');
			$data['text_elements'] = $this->language->get('text_elements');
				
			// Column
			$data['column_description'] = $this->language->get('column_description');
			$data['column_page_count'] = $this->language->get('column_page_count');
			$data['column_page_count_procent'] = $this->language->get('column_page_count_procent');
				
			// Button
			$data['button_solve'] = $this->language->get('button_solve');
				
			$analyse = false;
			$analyse = $this->cache->get('url_analyse.fast.' . md5($url));
				
			if ($analyse) {
				$data['analyse'] = $analyse;
				$data['result'] = $this->load->view($this->route . '/result', $data);
			} else {
				$data['progress']['value'] = 0;
				$data['progress']['info'] = sprintf($this->language->get('text_progress_info_found'), 0);
				$data['progress']['text'] = sprintf($this->language->get('text_progress_text'), 0);
			}
		}
		
		$data['error'] = $this->error;
				
		$this->response->setOutput(json_encode($data));
	}
	
	public function progress() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
		$this->load->model('setting/setting');
				
		// Setting
		$this->config->load($this->config_file);
		$config_setting = ($this->config->get($this->codename . '_setting')) ? $this->config->get($this->codename . '_setting') : array();
		
		$setting = $this->model_setting_setting->getSetting($this->codename);
		$status = isset($setting[$this->codename . '_status']) ? $setting[$this->codename . '_status'] : false;
		$setting = isset($setting[$this->codename . '_setting']) ? $setting[$this->codename . '_setting'] : array();
		
		if (!empty($setting)) {
			$config_setting = array_replace_recursive($config_setting, $setting);
		}
		
		$setting = $config_setting;
										
		if ($status && $this->validateURL()) {	
			$url = $this->request->get['url'];
											
			header('Content-Type: text/event-stream; charset=utf-8');
			header('Cache-Control: no-cache');
			
			$setting['fast']['progress'] = true;
					
			$analyse = $this->{'model_extension_module_' . $this->codename}->getAnalyserData($url, $setting['fast']);
					
			$this->cache->set('url_analyse.fast.' . md5($url), $analyse);
		}
	}
	
	public function send() {
		$this->load->language($this->route);
		
		$this->load->model($this->route);
		$this->load->model('setting/setting');
				
		// Setting
		$this->config->load($this->config_file);
		$config_setting = ($this->config->get($this->codename . '_setting')) ? $this->config->get($this->codename . '_setting') : array();
		
		$setting = $this->model_setting_setting->getSetting($this->codename);
		$status = isset($setting[$this->codename . '_status']) ? $setting[$this->codename . '_status'] : false;
		$setting = isset($setting[$this->codename . '_setting']) ? $setting[$this->codename . '_setting'] : array();
		
		if (!empty($setting)) {
			$config_setting = array_replace_recursive($config_setting, $setting);
		}
		
		$setting = $config_setting;
										
		if ($status && $this->validateURL() && $this->validateEmail()) {	
			$url = $this->request->get['url'];
			$method = $this->request->get['method'];
			$email = $this->request->get['email'];
			
			if (!isset($this->session->data['send'])) {
				$this->session->data['send'] = true;
				
				$data['success'] = $this->language->get('text_mail_send');
			} else {
				unset($this->session->data['send']);
								
				// Text		
				$data['text_rating'] = $this->language->get('text_rating');				
				$data['text_total_pages'] = $this->language->get('text_total_pages');
				$data['text_critical'] = $this->language->get('text_critical');
				$data['text_warning'] = $this->language->get('text_warning');
				$data['text_valid'] = $this->language->get('text_valid');
				$data['text_errors'] = $this->language->get('text_errors');
				$data['text_time'] = $this->language->get('text_time');
				$data['text_keywords'] = $this->language->get('text_keywords');
				$data['text_elements'] = $this->language->get('text_elements');
				
				// Column
				$data['column_description'] = $this->language->get('column_description');
				$data['column_page_count'] = $this->language->get('column_page_count');
				$data['column_page_count_procent'] = $this->language->get('column_page_count_procent');
				
				// Button
				$data['button_solve'] = $this->language->get('button_solve');
				
				$analyse = false;
				$analyse = $this->cache->get('url_analyse.' . $method . '.' . md5($url));
			
				if (!$analyse) {
					$setting[$method]['progress'] = false;
					
					$analyse = $this->{'model_extension_module_' . $this->codename}->getAnalyserData($url, $setting[$method]);
										
					$this->cache->set('url_analyse.' . $method . '.' . md5($url), $analyse);
				}
				
				if ($analyse) {
					$data['analyse'] = $analyse;
					$data['method'] = $method;
					$data['email'] = $email;
					
					$this->{'model_extension_module_' . $this->codename}->saveReport($data);
														
					$filename = $method . '-report-' . $data['analyse']['domain'] . '-' . date("Y-m-d-H-i-s");
				
					$fh = fopen(DIR_DOWNLOAD . $filename . '.html', 'w');
					fwrite($fh, $this->load->view($this->route . '/report', $data));
					fclose($fh);
				
					if ($this->{'model_extension_module_' . $this->codename}->zip(DIR_DOWNLOAD, array($filename . '.html'), $filename)) {
						$mail = new Mail();
						$mail->protocol = $this->config->get('config_mail_protocol');
						$mail->parameter = $this->config->get('config_mail_parameter');
						$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
						$mail->smtp_username = $this->config->get('config_mail_smtp_username');
						$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
						$mail->smtp_port = $this->config->get('config_mail_smtp_port');
						$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
						$mail->setTo($email);
						$mail->setFrom($this->config->get('config_email'));
						$mail->setSender($this->config->get('config_name'));
						$mail->setSubject(html_entity_decode(sprintf($this->language->get('text_mail_subject'), $data['analyse']['domain']), ENT_QUOTES, 'UTF-8'));
						$mail->setText(html_entity_decode(sprintf($this->language->get('text_mail_message'), $data['analyse']['domain']), ENT_QUOTES, 'UTF-8'));
						$mail->addAttachment(DIR_DOWNLOAD . $filename . '.zip');
						$mail->send();
													
						unlink(DIR_DOWNLOAD . $filename . '.zip');
					}
				
					unlink(DIR_DOWNLOAD . $filename . '.html');	
				}
			}
		}
		
		$data['error'] = $this->error;
				
		$this->response->setOutput(json_encode($data));
	}
	
	private function validateURL() {
		if (!isset($this->request->get['url']) || !isset($this->request->get['method']) || !isset($this->request->get['email'])) {
			return false;
		}
		
		$base_url = $this->{'model_extension_module_' . $this->codename}->getBaseURL($this->request->get['url']);
		
		if (!$base_url) {
			$this->error['url'] = $this->language->get('error_url');
			
			return false;
		}
		
		$this->request->get['url'] = $base_url;
				
		return true;
	}
			
	private function validateEmail() {		
		if (filter_var($this->request->get['email'], FILTER_VALIDATE_EMAIL) === false) {
			$this->error['email'] = $this->language->get('error_email');
			
			return false;
		}
		
		return true;
	}
}