<?php
class ControllerInformationCiquickcontact extends Controller {
	public function index() {
		if($this->config->get('ciquickcontact_status')) {
			$this->document->addStyle('catalog/view/theme/default/stylesheet/ciquickcontact.css');

			$this->load->language('information/ciquickcontact');

			$data['popup_position'] = $this->config->get('ciquickcontact_position');

			$data['ciquickcontact_css'] = $this->config->get('ciquickcontact_css');
			$data['ciquickcontact_width'] = $this->config->get('ciquickcontact_width');
			$data['popup_seconds'] = $this->config->get('ciquickcontact_popup_seconds') ? $this->config->get('ciquickcontact_popup_seconds') : 1;

			$ciquickcontact_description = $this->config->get('ciquickcontact_description');
			$lang_id = $this->config->get('config_language_id');

			$data['contact_title'] = isset($ciquickcontact_description[$lang_id]['title']) ? $ciquickcontact_description[$lang_id]['title'] : '';

			if ($this->request->server['HTTPS']) {
				$server = $this->config->get('config_ssl');
			} else {
				$server = $this->config->get('config_url');
			}

			if (is_file(DIR_IMAGE . $this->config->get('ciquickcontact_banner'))) {
				$data['banner_thumb'] = $server . 'image/' . $this->config->get('ciquickcontact_banner');
			} else {
				$data['banner_thumb'] = '';
			}

			$data['auto_popup'] = false;
			if($this->config->get('ciquickcontact_popup_status')) {
				$this->load->model('design/layout');
				if (isset($this->request->get['route'])) {
					$route = (string)$this->request->get['route'];
				} else {
					$route = 'common/home';
				}

				$layout_id = 0;

				if (!$layout_id) {
					$layout_id = $this->model_design_layout->getLayout($route);
				}

				if(in_array($layout_id, $this->config->get('ciquickcontact_popup_layout'))) {
					$popup_cokkies = false;

					if(!empty($this->request->cookie['ciquickcontact_popup_open'])) {
						$popup_cokkies = true;
					}

					if($this->config->get('ciquickcontact_popup_reopen')) {
						if(empty($this->request->cookie['ciquickcontact_popup_open'])) {
							setcookie('ciquickcontact_popup_open', 1, time() + (60 * $this->config->get('ciquickcontact_popup_minutes')), "/"); // 86400 = 1 Day
						}
					}else{
						if(empty($this->request->cookie['ciquickcontact_popup_open'])) {
							setcookie('ciquickcontact_popup_open', 1, time() + (86400 * 365), "/"); // 86400 = 1 Day 
						}
					}

					if(!$popup_cokkies) {
						$data['auto_popup'] = true;
					}
				}
			}

			return $this->load->view('information/ciquickcontact', $data);
		}
	}

	public function contact() {
		$ciquickcontact_description = $this->config->get('ciquickcontact_description');
		$lang_id = $this->config->get('config_language_id');

		$json = array();

		$this->load->language('information/ciquickcontact');

		$this->load->model('catalog/ciquickcontact');
		
		if ((utf8_strlen($this->request->post['contact_name']) < 3) || (utf8_strlen($this->request->post['contact_name']) > 32)) {
			$json['error_name'] = $this->language->get('error_name');
		}

		if (!filter_var($this->request->post['contact_email'], FILTER_VALIDATE_EMAIL)) {
			$json['error_email'] = $this->language->get('error_email');
		}

		if ((utf8_strlen($this->request->post['contact_enquiry']) < 10) || (utf8_strlen($this->request->post['contact_enquiry']) > 3000)) {
			$json['error_enquiry'] = $this->language->get('error_enquiry');
		}

		if(!$json) {

			// Save Request
			$this->model_catalog_ciquickcontact->addContactRequest($this->request->post);

			if($this->config->get('ciquickcontact_customer_email_status')) {
				if ($this->request->server['HTTPS']) {
					$server = $this->config->get('config_ssl');
				} else {
					$server = $this->config->get('config_url');
				}

				if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
					$logo = $server . 'image/' . $this->config->get('config_logo');
				} else {
					$logo = '';
				}
				

				$find = array(
					'{STORE_NAME}',
					'{STORE_LINK}',
					'{LOGO}',
					'{NAME}',
					'{EMAIL}',
					'{MESSAGE}',
				);
			
				$replace = array(
					'STORE_NAME'					=> $this->config->get('config_name'),
					'STORE_LINK'					=> $this->url->link('common/home', '', true),
					'LOGO'							=> '<img src="'. $logo .'" alt="'. $this->config->get('config_name') .'" title="'. $this->config->get('config_name') .'" />',
					'NAME'							=> $this->request->post['contact_name'],
					'EMAIL'							=> $this->request->post['contact_email'],
					'MESSAGE'						=> nl2br($this->request->post['contact_enquiry']),
				);
				
				$subject = !empty($ciquickcontact_description[$lang_id]['customer_subject']) ? html_entity_decode($ciquickcontact_description[$lang_id]['customer_subject'], ENT_QUOTES, 'UTF-8') : '';
				$message = !empty($ciquickcontact_description[$lang_id]['customer_message']) ? html_entity_decode($ciquickcontact_description[$lang_id]['customer_message'], ENT_QUOTES, 'UTF-8') : '';
				if(!empty($subject)) {
					$subject = str_replace($find, $replace, $subject);
				}else{
					$subject = '';
				}
				
				if(!empty($message)) {
					$message = str_replace($find, $replace, $message);
				}else{
					$message = '';
				}
				

				$mail = new Mail($this->config->get('config_mail_engine'));
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
				$mail->smtp_username = $this->config->get('config_mail_smtp_username');
				$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
				$mail->smtp_port = $this->config->get('config_mail_smtp_port');
				$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

				$mail->setTo($this->request->post['contact_email']);
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
				$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
				$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
				$mail->send();
			}

			if($this->config->get('ciquickcontact_admin_email_status')) {
				if ($this->request->server['HTTPS']) {
					$server = $this->config->get('config_ssl');
				} else {
					$server = $this->config->get('config_url');
				}

				if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
					$logo = $server . 'image/' . $this->config->get('config_logo');
				} else {
					$logo = '';
				}
				

				$find = array(
					'{STORE_NAME}',
					'{STORE_LINK}',
					'{LOGO}',
					'{NAME}',
					'{EMAIL}',
					'{MESSAGE}',
				);
			
				$replace = array(
					'STORE_NAME'					=> $this->config->get('config_name'),
					'STORE_LINK'					=> $this->url->link('common/home', '', true),
					'LOGO'							=> '<img src="'. $logo .'" alt="'. $this->config->get('config_name') .'" title="'. $this->config->get('config_name') .'" />',
					'NAME'							=> $this->request->post['contact_name'],
					'EMAIL'							=> $this->request->post['contact_email'],
					'MESSAGE'						=> nl2br($this->request->post['contact_enquiry']),
				);
				
				$subject = !empty($ciquickcontact_description[$lang_id]['admin_subject']) ? html_entity_decode($ciquickcontact_description[$lang_id]['admin_subject'], ENT_QUOTES, 'UTF-8') : '';
				$message = !empty($ciquickcontact_description[$lang_id]['admin_message']) ? html_entity_decode($ciquickcontact_description[$lang_id]['admin_message'], ENT_QUOTES, 'UTF-8') : '';
				if(!empty($subject)) {
					$subject = str_replace($find, $replace, $subject);
				}else{
					$subject = '';
				}
				
				if(!empty($message)) {
					$message = str_replace($find, $replace, $message);
				}else{
					$message = '';
				}
				

				$mail = new Mail($this->config->get('config_mail_engine'));
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
				$mail->smtp_username = $this->config->get('config_mail_smtp_username');
				$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
				$mail->smtp_port = $this->config->get('config_mail_smtp_port');
				$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

				$mail->setTo($this->config->get('config_email'));
				$mail->setFrom($this->request->post['contact_email']);
				$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
				$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
				$mail->setHtml(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
				$mail->send();
			}

			$json['success'] = true;
			$json['success_html'] = !empty($ciquickcontact_description[$lang_id]['success_description']) ? html_entity_decode($ciquickcontact_description[$lang_id]['success_description'], ENT_QUOTES, 'UTF-8') : $this->language->get('text_success');
		}


		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
