<?php
class ModelExtensionModuleDSEOAnalyser extends Model {
	private $codename = 'd_seo_analyser';
	
	/*
	*	Return Analyser Data.
	*/
	public function getAnalyserData($url, $setting) {		
		ini_set('memory_limit', $setting['memory_limit']);
		ini_set('max_execution_time', $setting['max_execution_time']);
		
		$data = array();
						
		if (file_exists(DIR_SYSTEM . 'library/d_crawler.php') && file_exists(DIR_SYSTEM . 'library/d_simple_html_dom.php')) {
			$crawler = new d_crawler($url, $setting['max_depth'], $setting['max_page'], $setting['max_thread']);
			
			if ($setting['progress']) {
				$callback_data['max_page'] = $setting['max_page'];
				$callback_data['text_progress_info'] = $this->language->get('text_progress_info_found');
				$callback_data['text_progress_text'] = $this->language->get('text_progress_text');
						
				$callback = function($pages) use ($callback_data) {
					$progress['value'] = round(50 * (count($pages) / $callback_data['max_page']));
					$progress['info'] = sprintf($callback_data['text_progress_info'], count($pages));
					$progress['text'] = sprintf($callback_data['text_progress_text'], $progress['value']);
							
					echo 'id: ' . time() . PHP_EOL;
					echo 'event: progress' . PHP_EOL;
					echo 'data: ' . json_encode($progress) . PHP_EOL;
					echo PHP_EOL;
					flush();
					ob_flush();
				};
			
				$crawler->setCallback($callback);
			}
		
			$pages = $crawler->run();
		
			$html_dom = new d_simple_html_dom();
		
			$base_url = '';
			$robots_empty_rating = 0;
			$opencart_rating = 0;
			$meta_title_duplicate = array();
						
			$unique_pages = $this->getUniquePages($pages, $setting['max_thread']);
			
			$data['pages'] = array();
			
			foreach ($pages as $page) {
				$data['pages'][$page['url']]['url'] = $page['url'];
				$data['pages'][$page['url']]['http_code'] = $page['http_code'];
				$data['pages'][$page['url']]['redirect_url'] = $page['redirect_url'];
				$data['pages'][$page['url']]['time'] = $page['time'];
				$data['pages'][$page['url']]['depth'] = $page['depth'];
				$data['pages'][$page['url']]['url_keyword'] = '';
				$data['pages'][$page['url']]['target_keywords'] = array();
				$data['pages'][$page['url']]['analyser_elements'] = array();
			
				$url_info = $this->getURLInfo($page['url']);
			
				if ($url_info['path']) {
					$path = explode('/', $url_info['path']);
					$data['pages'][$page['url']]['url_keyword'] = end($path);
				
					if ($data['pages'][$page['url']]['url_keyword'] == 'index.php') {
						$data['pages'][$page['url']]['url_keyword'] = '';
					}
				}
				
				if (($page['http_code'] >= 0) && ($page['http_code'] < 200)) {				
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'server_not_found',
						'name'			=> $this->language->get('text_server_not_found'),
						'description'	=> $this->language->get('help_server_not_found'),
						'link'			=> $this->language->get('link_server_not_found'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> 0,
						'weight'		=> 1
					);
				}
												
				if (($page['http_code'] >= 300) && ($page['http_code'] < 400)) {				
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'page_redirect',
						'name'			=> $this->language->get('text_page_redirect'),
						'description'	=> $this->language->get('help_page_redirect'),
						'link'			=> $this->language->get('link_page_redirect'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> 0.5,
						'weight'		=> 1
					);
				}
				
				if (($page['http_code'] >= 400) && ($page['http_code'] < 500)) {				
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'page_not_found',
						'name'			=> $this->language->get('text_page_not_found'),
						'description'	=> $this->language->get('help_page_not_found'),
						'link'			=> $this->language->get('link_page_not_found'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> 0,
						'weight'		=> 1
					);
				}
				
				if ($page['http_code'] >= 500) {				
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'server_error',
						'name'			=> $this->language->get('text_server_error'),
						'description'	=> $this->language->get('help_server_error'),
						'link'			=> $this->language->get('link_server_error'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> 0,
						'weight'		=> 1
					);
				}
													
				if (($page['http_code'] >= 200) && ($page['http_code'] < 300)) {
					$html_dom->load((string)$page['html'], $lowercase = true, $stripRN = false, $defaultBRText = DEFAULT_BR_TEXT);
					
					$data['pages'][$page['url']]['target_keywords'] = $this->getTargetKeywords($html_dom);
			
					if (!$base_url) {
						foreach ($html_dom->find('head base') as $element) {
							$base_url = $element->getAttribute('href');
						}
				
						if ($base_url) {
							$file_robots = $base_url . 'robots.txt';
		
							if (@fopen($file_robots, 'r') == true) { 
								$robots_txt_parser = new d_robots_txt_parser(file_get_contents($file_robots));
							}
					
							if (isset($robots_txt_parser) && $robots_txt_parser->getRules()) {
								$robots_empty_rating = 1;
							}
							
							if ($this->isOpencart($base_url)) {
								$opencart_rating = 1;
							}
						}			
					}
										
					$robots_no_index_rating = 1;
			
					if ($data['pages'][$page['url']]['url_keyword'] && isset($robots_txt_parser) && $robots_txt_parser->isUrlDisallow('/' . $data['pages'][$page['url']]['url_keyword'])) {
						$robots_no_index_rating = 0;
					}
						
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'robots_empty',
						'name'			=> $this->language->get('text_robots_empty'),
						'description'	=> $this->language->get('help_robots_empty'),
						'link'			=> $this->language->get('link_robots_empty'),
						'module'		=> $this->language->get('text_d_seo_module'),
						'rating'		=> $robots_empty_rating,
						'weight'		=> 1
					);

					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'robots_no_index',
						'name'			=> $this->language->get('text_robots_no_index'),
						'description'	=> $this->language->get('help_robots_no_index'),
						'link'			=> $this->language->get('link_robots_no_index'),
						'module'		=> $this->language->get('text_d_seo_module'),
						'rating'		=> $robots_no_index_rating,
						'weight'		=> 1
					);
					
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'opencart',
						'name'			=> $this->language->get('text_opencart'),
						'description'	=> $this->language->get('help_opencart'),
						'link'			=> $this->language->get('link_opencart'),
						'module'		=> $this->language->get('text_d_seo_module'),
						'rating'		=> $opencart_rating,
						'weight'		=> 1
					);
										
					$data['pages'][$page['url']]['meta_title'] = '';
			
					foreach ($html_dom->find('head title') as $element) {
						$data['pages'][$page['url']]['meta_title'] = htmlentities($element->innertext, ENT_QUOTES, 'UTF-8');
					}
			
					if ($data['pages'][$page['url']]['meta_title']) {
						if (!isset($meta_title_duplicate[$data['pages'][$page['url']]['meta_title']])) {
							$meta_title_duplicate[$data['pages'][$page['url']]['meta_title']] = 0;
						} else {
							$meta_title_duplicate[$data['pages'][$page['url']]['meta_title']]++;
						}
					}
			
					$data['pages'][$page['url']]['meta_description'] = '';
			
					foreach ($html_dom->find('head meta[name="description"]') as $element) {
						$data['pages'][$page['url']]['meta_description'] = htmlentities($element->getAttribute('content'), ENT_QUOTES, 'UTF-8');
					}
			
					$data['pages'][$page['url']]['custom_title_1'] = '';
			
					foreach ($html_dom->find('#content h1') as $element) {
						$data['pages'][$page['url']]['custom_title_1'] = htmlentities($element->innertext, ENT_QUOTES, 'UTF-8');
					}
			
					$data['pages'][$page['url']]['custom_title_2'] = '';
			
					foreach ($html_dom->find('#content h2') as $element) {
						$data['pages'][$page['url']]['custom_title_2'] = htmlentities($element->innertext, ENT_QUOTES, 'UTF-8');
					}
			
					$meta_robots_no_index_rating = 1;
					$meta_robots_no_follow_rating = 1;
							
					foreach ($html_dom->find('head meta[name="robots"]') as $element) {
						if (strpos($element->getAttribute('content'), 'noindex') !== false) {
							$meta_robots_no_index_rating = 0;
						}
				
						if (strpos($element->getAttribute('content'), 'nofollow') !== false) {
							$meta_robots_no_follow_rating = 0;
						}
					}
			
					$canonical_link = '';
							
					foreach ($html_dom->find('head link[rel="canonical"]') as $element) {
						$canonical_link = $element->getAttribute('href');
					}
			
					$prev_link = '';
							
					foreach ($html_dom->find('head link[rel="prev"]') as $element) {
						$prev_link = $element->getAttribute('href');
					}
			
					$next_link = '';
							
					foreach ($html_dom->find('head link[rel="next"]') as $element) {
						$next_link = $element->getAttribute('href');
					}
			
					$pagination = array();
							
					foreach ($html_dom->find('#content .pagination a') as $element) {
						$pagination[] = $element->getAttribute('href');
					}
				
					$alternate_link = array();
							
					foreach ($html_dom->find('head link[rel="alternate"]') as $element) {
						$language_code = $element->getAttribute('hreflang');
					
						if ($language_code) {
							$alternate_link[$language_code] = $element->getAttribute('href');
						}
					}
			
					$languages = array();
						
					foreach ($html_dom->find('#form-language .language-select') as $element) {
						$languages[] = preg_replace('/-(.+?)+/', '', $element->getAttribute('name'));
					}
				
					$alternate_link_count = 0;
				
					foreach ($languages as $language) {
						if (isset($alternate_link[$language])) {
							$alternate_link_count++;
						}
					}
											
					$meta_title_target_keyword_rating = 0;
					$meta_description_target_keyword_rating = 0;
					$custom_title_1_target_keyword_rating = 0;
					$custom_title_2_target_keyword_rating = 0;
					$url_keyword_target_keyword_rating = 0;
			
					if ($data['pages'][$page['url']]['target_keywords']) {
						$meta_title_target_keyword_count = 0;
						$meta_description_target_keyword_count = 0;
						$custom_title_1_target_keyword_count = 0;
						$custom_title_2_target_keyword_count = 0;
						$url_keyword_target_keyword_count = 0;
				
						foreach ($data['pages'][$page['url']]['target_keywords'] as $keyword) {
							if (strpos(mb_strtolower($data['pages'][$page['url']]['meta_title'], 'UTF-8'), mb_strtolower($keyword, 'UTF-8')) !== false) $meta_title_target_keyword_count++;
							if (strpos(mb_strtolower($data['pages'][$page['url']]['meta_description'], 'UTF-8'), mb_strtolower($keyword, 'UTF-8')) !== false) $meta_description_target_keyword_count++;
							if (strpos(mb_strtolower($data['pages'][$page['url']]['custom_title_1'], 'UTF-8'), mb_strtolower($keyword, 'UTF-8')) !== false) $custom_title_1_target_keyword_count++;
							if (strpos(mb_strtolower($data['pages'][$page['url']]['custom_title_2'], 'UTF-8'), mb_strtolower($keyword, 'UTF-8')) !== false) $custom_title_2_target_keyword_count++;
							if (strpos(mb_strtolower($data['pages'][$page['url']]['url_keyword'], 'UTF-8'), mb_strtolower($keyword, 'UTF-8')) !== false) $url_keyword_target_keyword_count++;
						}

						$meta_title_target_keyword_rating = 0.5 * ($meta_title_target_keyword_count / count($data['pages'][$page['url']]['target_keywords'])) + 0.5;
						$meta_description_target_keyword_rating = 0.5 * ($meta_description_target_keyword_count / count($data['pages'][$page['url']]['target_keywords'])) + 0.5;
						$custom_title_1_target_keyword_rating = 0.5 * ( $custom_title_1_target_keyword_count / count($data['pages'][$page['url']]['target_keywords'])) + 0.5;
						$custom_title_2_target_keyword_rating = 0.5 * ($custom_title_2_target_keyword_count / count($data['pages'][$page['url']]['target_keywords'])) + 0.5;
						$url_keyword_target_keyword_rating = 0.5 * ($url_keyword_target_keyword_count / count($data['pages'][$page['url']]['target_keywords'])) + 0.5;
					}
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_title_empty',
						'name'			=> $this->language->get('text_meta_title_empty'),
						'description'	=> $this->language->get('help_meta_title_empty'),
						'link'			=> $this->language->get('link_meta_title_empty'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $data['pages'][$page['url']]['meta_title'] ? 1 : 0,
						'weight'		=> 1
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_title_target_keyword',
						'name'			=> $this->language->get('text_meta_title_target_keyword'),
						'description'	=> $this->language->get('help_meta_title_target_keyword'),
						'link'			=> $this->language->get('link_meta_title_target_keyword'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $meta_title_target_keyword_rating,
						'weight'		=> 0.8
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_title_length',
						'name'			=> $this->language->get('text_meta_title_length'),
						'description'	=> $this->language->get('help_meta_title_length'),
						'link'			=> $this->language->get('link_meta_title_length'),
						'module'		=> $this->language->get('text_meta_title_length'),				
						'rating'		=> (mb_strlen($data['pages'][$page['url']]['meta_title'], 'UTF-8') > 60) ? 0 : 1,
						'weight'		=> 0.2
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_description_empty',
						'name'			=> $this->language->get('text_meta_description_empty'),
						'description'	=> $this->language->get('help_meta_description_empty'),
						'link'			=> $this->language->get('link_meta_description_empty'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $data['pages'][$page['url']]['meta_description'] ? 1 : 0,
						'weight'		=> 1
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_description_target_keyword',
						'name'			=> $this->language->get('text_meta_description_target_keyword'),
						'description'	=> $this->language->get('help_meta_description_target_keyword'),
						'link'			=> $this->language->get('link_meta_description_target_keyword'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $meta_description_target_keyword_rating,
						'weight'		=> 0.5
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_description_length',
						'name'			=> $this->language->get('text_meta_description_length'),
						'description'	=> $this->language->get('help_meta_description_length'),
						'link'			=> $this->language->get('link_meta_description_length'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),				
						'rating'		=> (mb_strlen($data['pages'][$page['url']]['meta_description'], 'UTF-8') > 160) ? 0 : 1,
						'weight'		=> 0.2
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'custom_title_1_target_keyword',
						'name'			=> $this->language->get('text_custom_title_1_target_keyword'),
						'description'	=> $this->language->get('help_custom_title_1_target_keyword'),
						'link'			=> $this->language->get('link_custom_title_1_target_keyword'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $custom_title_1_target_keyword_rating,
						'weight'		=> 1
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'custom_title_2_target_keyword',
						'name'			=> $this->language->get('text_custom_title_2_target_keyword'),
						'description'	=> $this->language->get('help_custom_title_2_target_keyword'),
						'link'			=> $this->language->get('link_custom_title_2_target_keyword'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $custom_title_2_target_keyword_rating,
						'weight'		=> 0.4
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_robots_no_index',
						'name'			=> $this->language->get('text_meta_robots_no_index'),
						'description'	=> $this->language->get('help_meta_robots_no_index'),
						'link'			=> $this->language->get('link_meta_robots_no_index'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $meta_robots_no_index_rating,
						'weight'		=> 1
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_robots_no_follow',
						'name'			=> $this->language->get('text_meta_robots_no_follow'),
						'description'	=> $this->language->get('help_meta_robots_no_follow'),
						'link'			=> $this->language->get('link_meta_robots_no_follow'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> $meta_robots_no_follow_rating,
						'weight'		=> 0.5
					);
						
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'url_keyword_empty',
						'name'			=> $this->language->get('text_url_keyword_empty'),
						'description'	=> $this->language->get('help_url_keyword_empty'),
						'link'			=> $this->language->get('link_url_keyword_empty'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> $data['pages'][$page['url']]['url_keyword'] ? 1 : 0,
						'weight'		=> 1
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'url_keyword_consistency',
						'name'			=> $this->language->get('text_url_keyword_consistency'),
						'description'	=> $this->language->get('help_url_keyword_consistency'),
						'link'			=> $this->language->get('link_url_keyword_consistency'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> ($data['pages'][$page['url']]['url_keyword'] && filter_var($base_url . $data['pages'][$page['url']]['url_keyword'], FILTER_VALIDATE_URL) === false) ? 0 : 1,
						'weight'		=> 1
					);
		
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'url_keyword_target_keyword',
						'name'			=> $this->language->get('text_url_keyword_target_keyword'),
						'description'	=> $this->language->get('help_url_keyword_target_keyword'),
						'link'			=> $this->language->get('link_url_keyword_target_keyword'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> $url_keyword_target_keyword_rating,
						'weight'		=> 0.8
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'url_keyword_length',
						'name'			=> $this->language->get('text_url_keyword_length'),
						'description'	=> $this->language->get('help_url_keyword_length'),
						'link'			=> $this->language->get('link_url_keyword_length'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> ($data['pages'][$page['url']]['url_keyword'] && (mb_strlen($data['pages'][$page['url']]['url_keyword'], 'UTF-8') > 100)) ? 0 : 1,
						'weight'		=> 0.2
					);
				
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'url_not_unique',
						'name'			=> $this->language->get('text_url_not_unique'),
						'description'	=> $this->language->get('help_url_not_unique'),
						'link'			=> $this->language->get('link_url_not_unique'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> (isset($unique_pages[$page['url']]) && $unique_pages[$page['url']]) ? 1 : 0,
						'weight'		=> 1
					);
			
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'canonical_link_empty',
						'name'			=> $this->language->get('text_canonical_link_empty'),
						'description'	=> $this->language->get('help_canonical_link_empty'),
						'link'			=> $this->language->get('link_canonical_link_empty'),
						'module'		=> $this->language->get('text_d_seo_module_url'),
						'rating'		=> $canonical_link ? 1 : 0,
						'weight'		=> 1
					);
			
					if ($pagination) {
						$data['pages'][$page['url']]['analyser_elements'][] = array(
							'code'			=> 'prev_next_link_empty',
							'name'			=> $this->language->get('text_prev_next_link_empty'),
							'description'	=> $this->language->get('help_prev_next_link_empty'),
							'link'			=> $this->language->get('link_prev_next_link_empty'),
							'module'		=> $this->language->get('text_d_seo_module_url'),
							'rating'		=> ($prev_link || $next_link) ? 1 : 0,
							'weight'		=> 1
						);
					}
								
					if ($languages) {
						$data['pages'][$page['url']]['analyser_elements'][] = array(
							'code'			=> 'multi_language_url',
							'name'			=> $this->language->get('text_multi_language_url'),
							'description'	=> $this->language->get('help_multi_language_url'),
							'link'			=> $this->language->get('link_multi_language_url'),
							'module'		=> $this->language->get('text_d_seo_module_url'),
							'rating'		=> ($alternate_link_count / count($languages)),
							'weight'		=> 1
						);
					}
										
					foreach ($html_dom->find('body') as $element) {
						if (strpos($element->getAttribute('class'), 'product-category') !== false) {
							$page_type = 'category';
						}
					
						if (strpos($element->getAttribute('class'), 'product-product') !== false) {
							$page_type = 'product';
						}
					
						if (strpos($element->getAttribute('class'), 'product-search') !== false) {
							$page_type = 'search';
						}
					}
			
					if (isset($page_type)) {			
						if ($page_type == 'product') {
							$opencart_product_review = 0;
				
							foreach ($html_dom->find('#review') as $element) {
								if ($element->innertext != '') {
									$opencart_product_review = 1;
								}
							}
				
							$data['pages'][$page['url']]['analyser_elements'][] = array(
								'code'			=> 'opencart_product_review',
								'name'			=> $this->language->get('text_opencart_product_review'),
								'description'	=> $this->language->get('help_opencart_product_review'),
								'link'			=> $this->language->get('link_opencart_product_review'),
								'module'		=> $this->language->get('text_d_seo_module'),
								'rating'		=> $opencart_product_review,
								'weight'		=> 1,
							);
						}
			
						if ($page_type == 'search') {
							if ($url_info['data']) {		
								if ($data['pages'][$page['url']]['meta_title'] && isset($url_info['data']['tag'])) {
									$opencart_search_tag = 0;
						
									if (strpos(mb_strtolower($data['pages'][$page['url']]['meta_title'], 'UTF-8'), mb_strtolower($url_info['data']['tag'], 'UTF-8')) !== false) {
										$opencart_search_tag = 1;
									}
						
									$data['pages'][$page['url']]['analyser_elements'][] = array(
										'code'			=> 'opencart_search_tag',
										'name'			=> $this->language->get('text_opencart_search_tag'),
										'description'	=> $this->language->get('help_opencart_search_tag'),
										'link'			=> $this->language->get('link_opencart_search_tag'),
										'module'		=> $this->language->get('text_d_seo_module'),
										'rating'		=> $opencart_search_tag,
										'weight'		=> 1,
									);
								}
							}
						}
					}
				}
				
				if ($setting['progress']) {
					$progress['value'] = 50 + round(50 * (count($data['pages']) / count($pages)));
					$progress['info'] = sprintf($this->language->get('text_progress_info_analysed'), count($data['pages']), count($pages));
					$progress['text'] = sprintf($this->language->get('text_progress_text'), $progress['value']);
							
					echo 'id: ' . time() . PHP_EOL;
					echo 'event: progress' . PHP_EOL;
					echo 'data: ' . json_encode($progress) . PHP_EOL;
					echo PHP_EOL;
					flush();
					ob_flush();
				}
			}
			
			$robots_empty_rating = 0;
			$robots_empty_count = 0;
			$robots_empty_total_count = 0;
			$robots_no_index_rating = 0;
			$robots_no_index_count = 0;
			$robots_no_index_total_count = 0;
			$opencart_rating = 0;
			$opencart_count = 0;
			$opencart_total_count = 0;
			$opencart_product_review_rating = 0;
			$opencart_product_review_count = 0;
			$opencart_product_review_total_count = 0;
			$opencart_search_tag_rating = 0;
			$opencart_search_tag_count = 0;
			$opencart_search_tag_total_count = 0;
			$meta_title_empty_rating = 0;
			$meta_title_empty_count = 0;
			$meta_title_empty_total_count = 0;
			$meta_title_duplicate_rating = 0;
			$meta_title_duplicate_count = 0;
			$meta_title_duplicate_total_count = 0;
			$meta_title_target_keyword_rating = 0;
			$meta_title_target_keyword_count = 0;
			$meta_title_target_keyword_total_count = 0;
			$meta_title_length_rating = 0;
			$meta_title_length_count = 0;
			$meta_title_length_total_count = 0;
			$meta_description_empty_rating = 0;
			$meta_description_empty_count = 0;
			$meta_description_empty_total_count = 0;
			$meta_description_target_keyword_rating = 0;
			$meta_description_target_keyword_count = 0;
			$meta_description_target_keyword_total_count = 0;
			$meta_description_length_rating = 0;
			$meta_description_length_count = 0;
			$meta_description_length_total_count = 0;
			$custom_title_1_target_keyword_rating = 0;
			$custom_title_1_target_keyword_count = 0;
			$custom_title_1_target_keyword_total_count = 0;
			$custom_title_2_target_keyword_rating = 0;
			$custom_title_2_target_keyword_count = 0;
			$custom_title_2_target_keyword_total_count = 0;
			$meta_robots_no_index_rating = 0;
			$meta_robots_no_index_count = 0;
			$meta_robots_no_index_total_count = 0;
			$meta_robots_no_follow_rating = 0;
			$meta_robots_no_follow_count = 0;
			$meta_robots_no_follow_total_count = 0;
			$server_not_found_rating = 0;
			$server_not_found_count = 0;
			$server_not_found_total_count = 0;
			$server_error_rating = 0;
			$server_error_count = 0;
			$server_error_total_count = 0;
			$page_not_found_rating = 0;
			$page_not_found_count = 0;
			$page_not_found_total_count = 0;
			$page_redirect_rating = 0;
			$page_redirect_count = 0;
			$page_redirect_total_count = 0;
			$url_keyword_empty_rating = 0;
			$url_keyword_empty_count = 0;
			$url_keyword_empty_total_count = 0;
			$url_keyword_consistency_rating = 0;
			$url_keyword_consistency_count = 0;
			$url_keyword_consistency_total_count = 0;
			$url_keyword_target_keyword_rating = 0;
			$url_keyword_target_keyword_count = 0;
			$url_keyword_target_keyword_total_count = 0;
			$url_keyword_length_rating = 0;
			$url_keyword_length_count = 0;
			$url_keyword_length_total_count = 0;
			$url_not_unique_rating = 0;
			$url_not_unique_count = 0;
			$url_not_unique_total_count = 0;
			$canonical_link_empty_rating = 0;
			$canonical_link_empty_count = 0;
			$canonical_link_empty_total_count = 0;
			$prev_next_link_empty_rating = 0;
			$prev_next_link_empty_count = 0;
			$prev_next_link_empty_total_count = 0;
			$multi_language_url_rating = 0;
			$multi_language_url_count = 0;
			$multi_language_url_total_count = 0;
			
			$data['error_element_count'] = 0;
			$data['critical_element_count'] = 0;
			$data['warning_element_count'] = 0;
			$data['valid_element_count'] = 0;
			$data['rating'] = 0;
				
			foreach ($data['pages'] as $page) {			
				if (($page['http_code'] >= 200) && ($page['http_code'] < 300)) {
					$data['pages'][$page['url']]['analyser_elements'][] = array(
						'code'			=> 'meta_title_duplicate',
						'name'			=> $this->language->get('text_meta_title_duplicate'),
						'description'	=> $this->language->get('help_meta_title_duplicate'),
						'link'			=> $this->language->get('link_meta_title_duplicate'),
						'module'		=> $this->language->get('text_d_seo_module_meta'),
						'rating'		=> (isset($meta_title_duplicate[$page['meta_title']]) && $meta_title_duplicate[$page['meta_title']]) ? (1 / ($meta_title_duplicate[$page['meta_title']])) : 1,
						'weight'		=> 1
					);
				}
				
				if (isset($data['pages'][$page['url']]['analyser_elements'])) {
					$data['pages'][$page['url']]['analyser_elements'] = $this->sortArrayByColumn($data['pages'][$page['url']]['analyser_elements'], 'rating');
				}
				
				$data['pages'][$page['url']]['error_element_count'] = 0;
				$data['pages'][$page['url']]['critical_element_count'] = 0;
				$data['pages'][$page['url']]['warning_element_count'] = 0;
				$data['pages'][$page['url']]['valid_element_count'] = 0;
								
				$total_rating = 0;
				$total_weight = 0;
					
				foreach ($data['pages'][$page['url']]['analyser_elements'] as $analyser_element) {
					if ($analyser_element['code'] == 'robots_empty') {
						$robots_empty_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $robots_empty_count++;
						$robots_empty_total_count++;
					}
					
					if ($analyser_element['code'] == 'robots_no_index') {
						$robots_no_index_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $robots_no_index_count++;
						$robots_no_index_total_count++;
					}
					
					if ($analyser_element['code'] == 'opencart') {
						$opencart_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $opencart_count++;
						$opencart_total_count++;
					}
					
					if ($analyser_element['code'] == 'opencart_product_review') {
						$opencart_product_review_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $opencart_product_review_count++;
						$opencart_product_review_total_count++;
					}
					
					if ($analyser_element['code'] == 'opencart_search_tag') {
						$opencart_search_tag_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $opencart_search_tag_count++;
						$opencart_search_tag_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_title_empty') {
						$meta_title_empty_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_title_empty_count++;
						$meta_title_empty_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_title_duplicate') {
						$meta_title_duplicate_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_title_duplicate_count++;
						$meta_title_duplicate_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_title_target_keyword') {
						$meta_title_target_keyword_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_title_target_keyword_count++;
						$meta_title_target_keyword_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_title_length') {
						$meta_title_length_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_title_length_count++;
						$meta_title_length_total_count++;
					}
										
					if ($analyser_element['code'] == 'meta_description_empty') {
						$meta_description_empty_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_description_empty_count++;
						$meta_description_empty_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_description_target_keyword') {
						$meta_description_target_keyword_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_description_target_keyword_count++;
						$meta_description_target_keyword_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_description_length') {
						$meta_description_length_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_description_length_count++;
						$meta_description_length_total_count++;
					}
					
					if ($analyser_element['code'] == 'custom_title_1_target_keyword') {
						$custom_title_1_target_keyword_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $custom_title_1_target_keyword_count++;
						$custom_title_1_target_keyword_total_count++;
					}
					
					if ($analyser_element['code'] == 'custom_title_2_target_keyword') {
						$custom_title_2_target_keyword_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $custom_title_2_target_keyword_count++;
						$custom_title_2_target_keyword_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_robots_no_index') {
						$meta_robots_no_index_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_robots_no_index_count++;
						$meta_robots_no_index_total_count++;
					}
					
					if ($analyser_element['code'] == 'meta_robots_no_follow') {
						$meta_robots_no_follow_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $meta_robots_no_follow_count++;
						$meta_robots_no_follow_total_count++;
					}
					
					if ($analyser_element['code'] == 'server_not_found') {
						$server_not_found_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $server_not_found_count++;
						$server_not_found_total_count++;
					}
					
					if ($analyser_element['code'] == 'server_error') {
						$server_error_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $server_error_count++;
						$server_error_total_count++;
					}
					
					if ($analyser_element['code'] == 'page_not_found') {
						$page_not_found_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $page_not_found_count++;
						$page_not_found_total_count++;
					}

					if ($analyser_element['code'] == 'page_redirect') {
						$page_redirect_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $page_redirect_count++;
						$page_redirect_total_count++;
					}
					
					if ($analyser_element['code'] == 'url_keyword_empty') {
						$url_keyword_empty_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $url_keyword_empty_count++;
						$url_keyword_empty_total_count++;
					}
					
					if ($analyser_element['code'] == 'url_keyword_consistency') {
						$url_keyword_consistency_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $url_keyword_consistency_count++;
						$url_keyword_consistency_total_count++;
					}
					
					if ($analyser_element['code'] == 'url_keyword_target_keyword') {
						$url_keyword_target_keyword_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $url_keyword_target_keyword_count++;
						$url_keyword_target_keyword_total_count++;
					}
					
					if ($analyser_element['code'] == 'url_keyword_length') {
						$url_keyword_length_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $url_keyword_length_count++;
						$url_keyword_length_total_count++;
					}
					
					if ($analyser_element['code'] == 'url_not_unique') {
						$url_not_unique_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $url_not_unique_count++;
						$url_not_unique_total_count++;
					}
					
					if ($analyser_element['code'] == 'canonical_link_empty') {
						$canonical_link_empty_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $canonical_link_empty_count++;
						$canonical_link_empty_total_count++;
					}
					
					if ($analyser_element['code'] == 'prev_next_link_empty') {
						$prev_next_link_empty_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $prev_next_link_empty_count++;
						$prev_next_link_empty_total_count++;
					}
					
					if ($analyser_element['code'] == 'multi_language_url') {
						$multi_language_url_rating += $analyser_element['rating'];
						if ($analyser_element['rating'] < 1) $multi_language_url_count++;
						$multi_language_url_total_count++;
					}
					
					if ($analyser_element['rating'] < 1) {
						$data['pages'][$page['url']]['error_element_count']++;
						$data['error_element_count']++;
						
						if ($analyser_element['rating'] < 0.4) {
							$data['pages'][$page['url']]['critical_element_count']++;
							$data['critical_element_count']++;
						} elseif ($analyser_element['rating'] < 0.8) {
							$data['pages'][$page['url']]['warning_element_count']++;
							$data['warning_element_count']++;
						} else {
							$data['pages'][$page['url']]['valid_element_count']++;
							$data['valid_element_count']++;
						}
					}
					
					$total_rating += $analyser_element['rating'] * $analyser_element['weight'];
					$total_weight += $analyser_element['weight'];
				}
														
				if ($total_weight) {
					$data['pages'][$page['url']]['rating'] = $total_rating / $total_weight;
				} else {
					$data['pages'][$page['url']]['rating'] = 0;
				}
				
				$data['rating'] += $data['pages'][$page['url']]['rating'];
			}
			
			$data['modules'] = array();
			$data['modules']['d_seo_module']['name'] = $this->language->get('text_d_seo_module');
			$data['modules']['d_seo_module_meta']['name'] = $this->language->get('text_d_seo_module_meta');
			$data['modules']['d_seo_module_url']['name'] = $this->language->get('text_d_seo_module_url');
						
			if ($robots_empty_total_count) {
				$data['modules']['d_seo_module']['analyser_elements'][] = array(
					'code'			=> 'robots_empty',
					'name'			=> $this->language->get('text_robots_empty'),
					'description'	=> $this->language->get('help_robots_empty'),
					'link'			=> $this->language->get('link_robots_empty'),
					'module'		=> $this->language->get('text_d_seo_module'),
					'rating'		=> $robots_empty_total_count ? ($robots_empty_rating / $robots_empty_total_count) : 0,
					'count'			=> $robots_empty_count,
					'total_count'	=> $robots_empty_total_count
				);
			}

			if ($robots_no_index_total_count) {
				$data['modules']['d_seo_module']['analyser_elements'][] = array(
					'code'			=> 'robots_no_index',
					'name'			=> $this->language->get('text_robots_no_index'),
					'description'	=> $this->language->get('help_robots_no_index'),
					'link'			=> $this->language->get('link_robots_no_index'),
					'module'		=> $this->language->get('text_d_seo_module'),
					'rating'		=> $robots_no_index_total_count ? ($robots_no_index_rating / $robots_no_index_total_count) : 0,
					'count'			=> $robots_no_index_count,
					'total_count'	=> $robots_no_index_total_count
				);
			}
			
			if ($opencart_total_count) {	
				$data['modules']['d_seo_module']['analyser_elements'][] = array(
					'code'			=> 'opencart',
					'name'			=> $this->language->get('text_opencart'),
					'description'	=> $this->language->get('help_opencart'),
					'link'			=> $this->language->get('link_opencart'),
					'module'		=> $this->language->get('text_d_seo_module'),
					'rating'		=> $opencart_total_count ? ($opencart_rating / $opencart_total_count) : 0,
					'count'			=> $opencart_count,
					'total_count'	=> $opencart_total_count
				);
			}
			
			if ($opencart_product_review_total_count) {	
				$data['modules']['d_seo_module']['analyser_elements'][] = array(
					'code'			=> 'opencart_product_review',
					'name'			=> $this->language->get('text_opencart_product_review'),
					'description'	=> $this->language->get('help_opencart_product_review'),
					'link'			=> $this->language->get('link_opencart_product_review'),
					'module'		=> $this->language->get('text_d_seo_module'),
					'rating'		=> $opencart_product_review_total_count ? ($opencart_product_review_rating / $opencart_product_review_total_count) : 0,
					'count'			=> $opencart_product_review_count,
					'total_count'	=> $opencart_product_review_total_count
				);
			}

			if ($opencart_search_tag_total_count) {	
				$data['modules']['d_seo_module']['analyser_elements'][] = array(
					'code'			=> 'opencart_search_tag',
					'name'			=> $this->language->get('text_opencart_search_tag'),
					'description'	=> $this->language->get('help_opencart_search_tag'),
					'link'			=> $this->language->get('link_opencart_search_tag'),
					'module'		=> $this->language->get('text_d_seo_module'),
					'rating'		=> $opencart_search_tag_total_count ? ($opencart_search_tag_rating / $opencart_search_tag_total_count) : 0,
					'count'			=> $opencart_search_tag_count,
					'total_count'	=> $opencart_search_tag_total_count
				);
			}
						
			if ($meta_title_empty_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_title_empty',
					'name'			=> $this->language->get('text_meta_title_empty'),
					'description'	=> $this->language->get('help_meta_title_empty'),
					'link'			=> $this->language->get('link_meta_title_empty'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $meta_title_empty_total_count ? ($meta_title_empty_rating / $meta_title_empty_total_count) : 0,
					'count'			=> $meta_title_empty_count,
					'total_count'	=> $meta_title_empty_total_count
				);
			}
			
			if ($meta_title_duplicate_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_title_duplicate',
					'name'			=> $this->language->get('text_meta_title_duplicate'),
					'description'	=> $this->language->get('help_meta_title_duplicate'),
					'link'			=> $this->language->get('link_meta_title_duplicate'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $meta_title_duplicate_total_count ? ($meta_title_duplicate_rating / $meta_title_duplicate_total_count) : 0,
					'count'			=> $meta_title_duplicate_count,
					'total_count'	=> $meta_title_duplicate_total_count
				);
			}
			
			if ($meta_title_target_keyword_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_title_target_keyword',
					'name'			=> $this->language->get('text_meta_title_target_keyword'),
					'description'	=> $this->language->get('help_meta_title_target_keyword'),
					'link'			=> $this->language->get('link_meta_title_target_keyword'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $meta_title_target_keyword_total_count ? ($meta_title_target_keyword_rating / $meta_title_target_keyword_total_count) : 0,
					'count'			=> $meta_title_target_keyword_count,
					'total_count'	=> $meta_title_target_keyword_total_count
				);
			}
			
			if ($meta_title_length_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_title_length',
					'name'			=> $this->language->get('text_meta_title_length'),
					'description'	=> $this->language->get('help_meta_title_length'),
					'link'			=> $this->language->get('link_meta_title_length'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),				
					'rating'		=> $meta_title_length_total_count ? ($meta_title_length_rating / $meta_title_length_total_count) : 0,
					'count'			=> $meta_title_length_count,
					'total_count'	=> $meta_title_length_total_count
				);
			}
			
			if ($meta_description_empty_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_description_empty',
					'name'			=> $this->language->get('text_meta_description_empty'),
					'description'	=> $this->language->get('help_meta_description_empty'),
					'link'			=> $this->language->get('link_meta_description_empty'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $meta_description_empty_total_count ? ($meta_description_empty_rating / $meta_description_empty_total_count) : 0,
					'count'			=> $meta_description_empty_count,
					'total_count'	=> $meta_description_empty_total_count
				);
			}
			
			if ($meta_description_target_keyword_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_description_target_keyword',
					'name'			=> $this->language->get('text_meta_description_target_keyword'),
					'description'	=> $this->language->get('help_meta_description_target_keyword'),
					'link'			=> $this->language->get('link_meta_description_target_keyword'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $meta_description_target_keyword_total_count ? ($meta_description_target_keyword_rating / $meta_description_target_keyword_total_count) : 0,
					'count'			=> $meta_description_target_keyword_count,
					'total_count'	=> $meta_description_target_keyword_total_count
				);
			}
			
			if ($meta_description_length_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_description_length',
					'name'			=> $this->language->get('text_meta_description_length'),
					'description'	=> $this->language->get('help_meta_description_length'),
					'link'			=> $this->language->get('link_meta_description_length'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),				
					'rating'		=> $meta_description_length_total_count ? ($meta_description_length_rating / $meta_description_length_total_count) : 0,
					'count'			=> $meta_description_length_count,
					'total_count'	=> $meta_description_length_total_count
				);
			}
			
			if ($custom_title_1_target_keyword_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'custom_title_1_target_keyword',
					'name'			=> $this->language->get('text_custom_title_1_target_keyword'),
					'description'	=> $this->language->get('help_custom_title_1_target_keyword'),
					'link'			=> $this->language->get('link_custom_title_1_target_keyword'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $custom_title_1_target_keyword_total_count ? ($custom_title_1_target_keyword_rating / $custom_title_1_target_keyword_total_count) : 0,
					'count'			=> $custom_title_1_target_keyword_count,
					'total_count'	=> $custom_title_1_target_keyword_total_count
				);
			}
			
			if ($custom_title_2_target_keyword_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'custom_title_2_target_keyword',
					'name'			=> $this->language->get('text_custom_title_2_target_keyword'),
					'description'	=> $this->language->get('help_custom_title_2_target_keyword'),
					'link'			=> $this->language->get('link_custom_title_2_target_keyword'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $custom_title_2_target_keyword_total_count ? ($custom_title_2_target_keyword_rating / $custom_title_2_target_keyword_total_count) : 0,
					'count'			=> $custom_title_2_target_keyword_count,
					'total_count'	=> $custom_title_2_target_keyword_total_count
				);
			}
			
			if ($meta_robots_no_index_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_robots_no_index',
					'name'			=> $this->language->get('text_meta_robots_no_index'),
					'description'	=> $this->language->get('help_meta_robots_no_index'),
					'link'			=> $this->language->get('link_meta_robots_no_index'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $meta_robots_no_index_total_count ? ($meta_robots_no_index_rating / $meta_robots_no_index_total_count) : 0,
					'count'			=> $meta_robots_no_index_count,
					'total_count'	=> $meta_robots_no_index_total_count
				);
			}
			
			if ($meta_robots_no_follow_total_count) {
				$data['modules']['d_seo_module_meta']['analyser_elements'][] = array(
					'code'			=> 'meta_robots_no_follow',
					'name'			=> $this->language->get('text_meta_robots_no_follow'),
					'description'	=> $this->language->get('help_meta_robots_no_follow'),
					'link'			=> $this->language->get('link_meta_robots_no_follow'),
					'module'		=> $this->language->get('text_d_seo_module_meta'),
					'rating'		=> $meta_robots_no_follow_total_count ? ($meta_robots_no_follow_rating / $meta_robots_no_follow_total_count) : 0,
					'count'			=> $meta_robots_no_follow_count,
					'total_count'	=> $meta_robots_no_follow_total_count
				);
			}
			
			if ($server_not_found_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'server_not_found',
					'name'			=> $this->language->get('text_server_not_found'),
					'description'	=> $this->language->get('help_server_not_found'),
					'link'			=> $this->language->get('link_server_not_found'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $server_not_found_total_count ? ($server_not_found_rating / $server_not_found_total_count) : 0,
					'count'			=> $server_not_found_count,
					'total_count'	=> $server_not_found_total_count
				);
			}
			
			if ($server_error_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'server_error',
					'name'			=> $this->language->get('text_server_error'),
					'description'	=> $this->language->get('help_server_error'),
					'link'			=> $this->language->get('link_server_error'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $server_error_total_count ? ($server_error_rating / $server_error_total_count) : 0,
					'count'			=> $server_error_count,
					'total_count'	=> $server_error_total_count
				);
			}
			
			if ($page_not_found_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'page_not_found',
					'name'			=> $this->language->get('text_page_not_found'),
					'description'	=> $this->language->get('help_page_not_found'),
					'link'			=> $this->language->get('link_page_not_found'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $page_not_found_total_count ? ($page_not_found_rating / $page_not_found_total_count) : 0,
					'count'			=> $page_not_found_count,
					'total_count'	=> $page_not_found_total_count
				);
			}
			
			if ($page_redirect_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'page_redirect',
					'name'			=> $this->language->get('text_page_redirect'),
					'description'	=> $this->language->get('help_page_redirect'),
					'link'			=> $this->language->get('link_page_redirect'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $page_redirect_total_count ? ($page_redirect_rating / $page_redirect_total_count) : 0,
					'count'			=> $page_redirect_count,
					'total_count'	=> $page_redirect_total_count
				);
			}
						
			if ($url_keyword_empty_total_count) {			
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'url_keyword_empty',
					'name'			=> $this->language->get('text_url_keyword_empty'),
					'description'	=> $this->language->get('help_url_keyword_empty'),
					'link'			=> $this->language->get('link_url_keyword_empty'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $url_keyword_empty_total_count ? ($url_keyword_empty_rating / $url_keyword_empty_total_count) : 0,
					'count'			=> $url_keyword_empty_count,
					'total_count'	=> $url_keyword_empty_total_count
				);
			}
			
			if ($url_keyword_consistency_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'url_keyword_consistency',
					'name'			=> $this->language->get('text_url_keyword_consistency'),
					'description'	=> $this->language->get('help_url_keyword_consistency'),
					'link'			=> $this->language->get('link_url_keyword_consistency'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $url_keyword_consistency_total_count ? ($url_keyword_consistency_rating / $url_keyword_consistency_total_count) : 0,
					'count'			=> $url_keyword_consistency_count,
					'total_count'	=> $url_keyword_consistency_total_count
				);
			}
			
			if ($url_keyword_target_keyword_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'url_keyword_target_keyword',
					'name'			=> $this->language->get('text_url_keyword_target_keyword'),
					'description'	=> $this->language->get('help_url_keyword_target_keyword'),
					'link'			=> $this->language->get('link_url_keyword_target_keyword'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $url_keyword_target_keyword_total_count ? ($url_keyword_target_keyword_rating / $url_keyword_target_keyword_total_count) : 0,
					'count'			=> $url_keyword_target_keyword_count,
					'total_count'	=> $url_keyword_target_keyword_total_count
				);
			}
			
			if ($url_keyword_length_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'url_keyword_length',
					'name'			=> $this->language->get('text_url_keyword_length'),
					'description'	=> $this->language->get('help_url_keyword_length'),
					'link'			=> $this->language->get('link_url_keyword_length'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $url_keyword_length_total_count ? ($url_keyword_length_rating / $url_keyword_length_total_count) : 0,
					'count'			=> $url_keyword_length_count,
					'total_count'	=> $url_keyword_length_total_count
				);
			}
			
			if ($url_not_unique_total_count) {			
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'url_not_unique',
					'name'			=> $this->language->get('text_url_not_unique'),
					'description'	=> $this->language->get('help_url_not_unique'),
					'link'			=> $this->language->get('link_url_not_unique'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $url_not_unique_total_count ? ($url_not_unique_rating / $url_not_unique_total_count) : 0,
					'count'			=> $url_not_unique_count,
					'total_count'	=> $url_not_unique_total_count
				);
			}
			
			if ($canonical_link_empty_total_count) {
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'canonical_link_empty',
					'name'			=> $this->language->get('text_canonical_link_empty'),
					'description'	=> $this->language->get('help_canonical_link_empty'),
					'link'			=> $this->language->get('link_canonical_link_empty'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $canonical_link_empty_total_count ? ($canonical_link_empty_rating / $canonical_link_empty_total_count) : 0,
					'count'			=> $canonical_link_empty_count,
					'total_count'	=> $canonical_link_empty_total_count
				);
			}
			
			if ($prev_next_link_empty_total_count) {		
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'prev_next_link_empty',
					'name'			=> $this->language->get('text_prev_next_link_empty'),
					'description'	=> $this->language->get('help_prev_next_link_empty'),
					'link'			=> $this->language->get('link_prev_next_link_empty'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $prev_next_link_empty_total_count ? ($prev_next_link_empty_rating / $prev_next_link_empty_total_count) : 0,
					'count'			=> $prev_next_link_empty_count,
					'total_count'	=> $prev_next_link_empty_total_count
				);
			}
					
			if ($multi_language_url_total_count) {					
				$data['modules']['d_seo_module_url']['analyser_elements'][] = array(
					'code'			=> 'multi_language_url',
					'name'			=> $this->language->get('text_multi_language_url'),
					'description'	=> $this->language->get('help_multi_language_url'),
					'link'			=> $this->language->get('link_multi_language_url'),
					'module'		=> $this->language->get('text_d_seo_module_url'),
					'rating'		=> $multi_language_url_total_count ? ($multi_language_url_rating / $multi_language_url_total_count) : 0,
					'count'			=> $multi_language_url_count,
					'total_count'	=> $multi_language_url_total_count
				);
			}
			
			if (isset($data['modules']['d_seo_module']['analyser_elements'])) {
				$data['modules']['d_seo_module']['analyser_elements'] = $this->sortArrayByColumn($data['modules']['d_seo_module']['analyser_elements'], 'rating');
			}
			
			if (isset($data['modules']['d_seo_module_meta']['analyser_elements'])) {
				$data['modules']['d_seo_module_meta']['analyser_elements'] = $this->sortArrayByColumn($data['modules']['d_seo_module_meta']['analyser_elements'], 'rating');
			}
			
			if (isset($data['modules']['d_seo_module_url']['analyser_elements'])) {
				$data['modules']['d_seo_module_url']['analyser_elements'] = $this->sortArrayByColumn($data['modules']['d_seo_module_url']['analyser_elements'], 'rating');
			}
								
			if (count($data['pages']) > 0) {
				$data['rating'] = $data['rating'] / count($data['pages']);
			}
			
			if ($base_url) {			
				$url_info = $this->getURLInfo($base_url);
			} else {
				$url_info = $this->getURLInfo($url);
			}
						
			$data['domain'] = trim($url_info['host'] . $url_info['port'] . $url_info['path'], '/');
			$data['image'] = $this->getHomePageImage($base_url);
			$data['date'] = date('d.m.Y');
		}
		
		return $data;
	}
	
	/*
	*	Return Base URL.
	*/
	public function getBaseURL($url) {
		$url = str_replace('http://', '', $url);
		$url = str_replace('https://', '', $url);
		
		$ch = curl_init($url);	
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);	
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		curl_setopt($ch, CURLOPT_MAXREDIRS, 10);		
		$html = curl_exec($ch);
		$info = curl_getinfo($ch);
		curl_close($ch);
		
		if (($info['http_code'] >= 200) && ($info['http_code'] < 300)) {
			$base_url = $info['url'];
			
			if (file_exists(DIR_SYSTEM . 'library/d_simple_html_dom.php')) {
				$html_dom = new d_simple_html_dom();
				
				$html_dom->load($html, $lowercase = true, $stripRN = false, $defaultBRText = DEFAULT_BR_TEXT);
			
				foreach ($html_dom->find('head base') as $element) {
					$base_url = $element->getAttribute('href');
				}
			}
			
			return $base_url;
		}
		
		return false;
	}
	
	/*
	*	Save Report.
	*/
	public function saveReport($data) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "d_seo_analyser_customer WHERE email = '" . $this->db->escape($data['email']) . "'");
		
		if ($query->row) {
			$customer_id = $query->row['customer_id'];
		} else {
			$this->db->query("INSERT INTO " . DB_PREFIX . "d_seo_analyser_customer SET email = '" . $this->db->escape($data['email']) . "'");
			
			$customer_id = $this->db->getLastId();
		}
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "d_seo_analyser_url WHERE url = '" . $this->db->escape($data['analyse']['domain']) . "'");
		
		if ($query->row) {
			$url_id = $query->row['url_id'];
		} else {
			$this->db->query("INSERT INTO " . DB_PREFIX . "d_seo_analyser_url SET url = '" . $this->db->escape($data['analyse']['domain']) . "'");
			
			$url_id = $this->db->getLastId();
		}
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "d_seo_analyser_url_to_customer WHERE url_id = '" . (int)$url_id . "' AND customer_id = '" . (int)$customer_id . "'");
		
		if (!$query->row) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "d_seo_analyser_url_to_customer SET url_id = '" . (int)$url_id . "', customer_id = '" . (int)$customer_id . "'");
		}
				
		$this->db->query("INSERT INTO " . DB_PREFIX . "d_seo_analyser_history SET customer_id = '" . (int)$customer_id . "', url_id = '" . (int)$url_id . "', method = '" . $this->db->escape($data['method']) . "', rating = '" . (int)(100 * $data['analyse']['rating']) . "', date_added = NOW()");
	}
	
	/*
	*	Create Zip File.
	*/
	public function zip($cur_dir, $elements, $filename) {
		$arr_elements = array();
		
		foreach ($elements as $element) {
			if ($element) {
				if (is_dir($cur_dir . $element)) {
					if ($this->is_empty_dir($cur_dir . $element)) $arr_elements[] = array('name' => (string)$element, 'type' => 'dir');
					$this->scan_dir($cur_dir . $element, $arr_elements);
				} 
				
				if (is_file($cur_dir . $element)) {
					$arr_elements[] = array('name' => (string)$element, 'type' => 'file');
				}
			}
		}
		
		$zip = new ZipArchive();
		
		$res = $zip->open($cur_dir . $filename . '.zip', ZipArchive::CREATE | ZipArchive::OVERWRITE);
		
		if ($res === TRUE) {
			foreach ($arr_elements as $element) {
				$element['name'] = str_replace($cur_dir, "", $element['name']);
				
				if ($element['type']=='dir') {
					$zip->addEmptyDir($element['name']); 
				}
				
				if ($element['type']=='file') {
					$zip->addFile($cur_dir . $element['name'], $element['name']);
				}    
			}
			
			$zip->close();
			
			return true;
        }
		
		return false;
	}
	
	/*
	*	Return Unique Pages.
	*/
	private function getUniquePages($pages, $max_thread) {
		$duplicate_urls = array();
		$url_by_duplicate_url = array();
		
		foreach ($pages as $page) {
			if (($page['http_code'] >= 200) && ($page['http_code'] < 300)) {
				$url_info = $this->getURLInfo($page['url']);
				
				$duplicate_url = $url_info['scheme'] . $url_info['user'] . $url_info['pass'] . $url_info['host'] . $url_info['port'] . $url_info['path'] . '//' . $url_info['query'];   			
				$duplicate_urls[] = $duplicate_url;
				$url_by_duplicate_url[$duplicate_url] = $page['url'];
			}
		}

		$unique_pages = array();	
						
		while ($duplicate_urls) {
			$cmh = curl_multi_init();
				
			$thread = 0;
				
			while ($duplicate_urls && ($thread <= $max_thread)) {
				$duplicate_url = array_shift($duplicate_urls);
					
				$ch = curl_init($duplicate_url);
					
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
					
				curl_multi_add_handle($cmh, $ch);
					
				$thread++;
			}
				
			$active = null;
				
			do {
				$mrc = curl_multi_exec($cmh, $active);
			} while ($mrc == CURLM_CALL_MULTI_PERFORM);

			while ($active && ($mrc == CURLM_OK)) {
				if (curl_multi_select($cmh) == -1) {
					usleep(1);
				}
					
				do {
					$mrc = curl_multi_exec($cmh, $active);
					$info = curl_multi_info_read($cmh);
							
					if ($info['msg'] == CURLMSG_DONE) {
						$ch = $info['handle'];
							
						$html = curl_multi_getcontent($ch);
						$info = curl_getinfo($ch);
						$url = $url_by_duplicate_url[$info['url']];
						
						if ($html != $pages[$url]['html']) {
							$unique_pages[$url] = 1;
						} else {
							$unique_pages[$url] = 0;
						}
																					
						curl_multi_remove_handle($cmh, $ch);
							
						if ($duplicate_urls) {
							$duplicate_url = array_shift($duplicate_urls);
								
							$ch = curl_init($duplicate_url);
							
							curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
					
							curl_multi_add_handle($cmh, $ch);
						} else {
							curl_close($ch);
						}
					}
				} while ($mrc == CURLM_CALL_MULTI_PERFORM);
			}
				
			curl_multi_close($cmh);
		}
		
		return $unique_pages;
	}
	
	/*
	*	Validate Opencart.
	*/
	private function isOpencart($base_url) {
		$cmh = curl_multi_init();
								
		$ch = curl_init($base_url);	
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);	
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		curl_setopt($ch, CURLOPT_MAXREDIRS, 10);		
		curl_multi_add_handle($cmh, $ch);
		
		$ch = curl_init($base_url . 'index.php?route=product/special');	
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		curl_setopt($ch, CURLOPT_MAXREDIRS, 10);		
		curl_multi_add_handle($cmh, $ch);
		
		$html = array();
									
		$active = null;
				
		do {
			$mrc = curl_multi_exec($cmh, $active);
		} while ($mrc == CURLM_CALL_MULTI_PERFORM);

		while ($active && ($mrc == CURLM_OK)) {
			if (curl_multi_select($cmh) == -1) {
				usleep(1);
			}
					
			do {
				$mrc = curl_multi_exec($cmh, $active);
				$info = curl_multi_info_read($cmh);
							
				if ($info['msg'] == CURLMSG_DONE) {
					$ch = $info['handle'];
							
					$html[$ch] = curl_multi_getcontent($ch);

					curl_multi_remove_handle($cmh, $ch);
							
					curl_close($ch);
				}
			} while ($mrc == CURLM_CALL_MULTI_PERFORM);
		}
				
		curl_multi_close($cmh);
		
		if (reset($html) != end($html)) {
			return true;
		} else {
			return false;
		}
	}
	
	/*
	*	Return Home Page Image.
	*/
	private function getHomePageImage($url) {
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = HTTPS_SERVER;
		} else {
			$server = HTTP_SERVER;
		}
		
		$this->clearImages();
		
		$filename = DIR_IMAGE . 'catalog/' . $this->codename . '/' . md5($url) . '.png';
		
		if (!file_exists($filename)) {
			$service_url = 'http://api.screenshotlayer.com/api/capture?access_key=71bb2076df45beafcd1cdd91bc5a2816&url=' . urlencode($url) . '&width=450&viewport=1440x900&format=PNG';
		
			$ch = curl_init($service_url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			$content = curl_exec($ch);
			curl_close($ch);
			
			$result = json_decode($content, true);
			
			if (!isset($result['error'])) {
				$fh = fopen($filename, "w");
				fwrite($fh, $content);
				fclose($fh);
			}
		}
		
		if (file_exists($filename)) {
			return str_replace(DIR_IMAGE, $server . 'image/', $filename);
		} else {
			return false;
		}
	}
	
	/*
	*	Return Target Keywords.
	*/
	private function getTargetKeywords($html_dom, $limit = 3) {
		$keyword_frequency = array();
		
		foreach($html_dom->find('script, style, map, iframe, frameset, object, applet, comment, button, textarea, select, a, .a') as $element) {
			$element->outertext = '';
		}
		
		$html_dom->load($html_dom->save());
		
		$keyword_frequency = $this->getKeywordFrequencyByTag($keyword_frequency, $html_dom, 'body', 1.0);
		$keyword_frequency = $this->getKeywordFrequencyByTag($keyword_frequency, $html_dom, 'body h6', 1.0);
		$keyword_frequency = $this->getKeywordFrequencyByTag($keyword_frequency, $html_dom, 'body h5', 1.2);
		$keyword_frequency = $this->getKeywordFrequencyByTag($keyword_frequency, $html_dom, 'body h4', 1.4);
		$keyword_frequency = $this->getKeywordFrequencyByTag($keyword_frequency, $html_dom, 'body h3', 1.6);
		$keyword_frequency = $this->getKeywordFrequencyByTag($keyword_frequency, $html_dom, 'body h2', 1.8);
		$keyword_frequency = $this->getKeywordFrequencyByTag($keyword_frequency, $html_dom, 'body h1', 2.0);
		
		asort($keyword_frequency, SORT_NUMERIC);
		
		$target_keywords = array_keys(array_reverse($keyword_frequency));
		
		$target_keywords = array_slice($target_keywords, 0, $limit);
				
		return $target_keywords;
	}
		
	private function getKeywordFrequencyByTag($keyword_frequency, $html_dom, $tag, $weight) {
		foreach($html_dom->find($tag) as $element) {
			$keywords = preg_split('/[\s,.!?\(\)]+/', strip_tags($element->plaintext));
			
			foreach ($keywords as $keyword) {
				if (mb_strlen(html_entity_decode($keyword), 'UTF-8') >= 5) {
					$keyword = htmlentities($keyword, ENT_QUOTES, 'UTF-8');
					
					if (!isset($keyword_frequency[$keyword])) {
						$keyword_frequency[$keyword] = $weight;
					} else {
						$keyword_frequency[$keyword] = $keyword_frequency[$keyword] + $keyword_frequency[$keyword] * $weight;
					}
				}
			}
		}
		
		return $keyword_frequency;
	}
	
	/*
	*	Return URL Info.
	*/	
	private function getURLInfo($url) {						
		$url_info = parse_url(str_replace('&amp;', '&', $url));
		
		$url_info['scheme'] = isset($url_info['scheme']) ? $url_info['scheme'] . '://' : '';
		$url_info['user'] = isset($url_info['user']) ? $url_info['user'] : '';
		$url_info['pass'] = isset($url_info['pass']) ? ':' . $url_info['pass']  : '';
		$url_info['pass'] = ($url_info['user'] || $url_info['pass']) ? $url_info['pass'] . '@' : ''; 
		$url_info['host'] = isset($url_info['host']) ? $url_info['host'] : '';
		$url_info['port'] = isset($url_info['port']) ? ':' . $url_info['port'] : '';
		$url_info['path'] = isset($url_info['path']) ? $url_info['path'] : '';		
		
		$url_info['data'] = array();
		
		if (isset($url_info['query'])) {
			parse_str($url_info['query'], $url_info['data']);
		}
		
		$url_info['query'] = isset($url_info['query']) ? '?' . $url_info['query'] : '';
		$url_info['fragment'] = isset($url_info['fragment']) ? '#' . $url_info['fragment'] : '';
						
		return $url_info;
	}
		
	/*
	*	Sort Array By Column.
	*/
	private function sortArrayByColumn($arr, $col, $dir = SORT_ASC) {
		$sort_col = array();
		$sort_key = array();
		
		foreach ($arr as $key => $row) {
			$sort_key[$key] = $key;
			
			if (isset($row[$col])) {
				$sort_col[$key] = $row[$col];
			} else {
				$sort_col[$key] = '';
			}
		}
		
		array_multisort($sort_col, $dir, $sort_key, SORT_ASC, $arr);
		
		return $arr;
	}
	
	/*
	*	Clear Images.
	*/
	private function clearImages() {
		$arr_files = array(); 
		
		$path = DIR_IMAGE . 'catalog/' . $this->codename;
		
		$this->scan_dir($path, $arr_files);
		
		$dt = date('Y-m-d H:i:s');
		
		foreach ($arr_files as $key => $file) {
			$df = date('Y-m-d H:i:s', filemtime($file['name']));
			$day_count = floor(((strtotime($dt) - strtotime($df)) / 86400));
			if ($day_count > 60) unlink($file['name']);
		}
	}
		
	/*
	*	Scan Dir.
	*/
	private function scan_dir($dir, &$arr_elements) {
		if (is_dir($dir)) {
			if ($this->is_empty_dir($dir)) $arr_elements[] = array('name' => $dir, 'type' => 'dir');
           
		    $handle = opendir($dir);
            
			while ($element = readdir($handle)) {
                if ($element == '.' or $element == '..') continue;
                if (is_file($element)) $arr_elements[] = array('name' => $dir . "/" . $element, 'type' => 'file');
                else $this->scan_dir($dir . "/" . $element, $arr_elements);
            }
			
            closedir($handle);
        } else {
            $arr_elements[] = array('name' => $dir, 'type' => 'file');
        }
		
    }
	
	/*
	*	Validation Empty Dir.
	*/
    private function is_empty_dir($dir) {
        if (!is_readable($dir))
            return true;

        $handle = opendir($dir);
		
        while (false !== ($entry = readdir($handle))) {
            if ($entry != "." && $entry != "..") {
                return false;
            }
        }
		
        return true;
    }
}