/**
 * jQuery plugin for Sortable
 * @author	RubaXa   <trash@rubaxa.org>
 * @license MIT
 */
(function (factory) {
	"use strict";

	if (typeof define === "function" && define.amd) {
		define(["jquery"], factory);
	}
	else {
		/* jshint sub:true */
		factory(jQuery);
	}
})(function ($) {
	"use strict";


	/* CODE */


	/**
	 * jQuery plugin for Sortable
	 * @param   {Object|String} options
	 * @param   {..*}           [args]
	 * @returns {jQuery|*}
	 */
	$.fn.sortable = function (options) {
		var retVal,
			args = arguments;

		this.each(function () {
			var $el = $(this),
				sortable = $el.data('sortable');

			if (!sortable && (options instanceof Object || !options)) {
				sortable = new Sortable(this, options);
				$el.data('sortable', sortable);
			}

			if (sortable) {
				if (options === 'widget') {
					return sortable;
				}
				else if (options === 'destroy') {
					sortable.destroy();
					$el.removeData('sortable');
				}
				else if (typeof sortable[options] === 'function') {
					retVal = sortable[options].apply(sortable, [].slice.call(args, 1));
				}
				else if (options in sortable.options) {
					retVal = sortable.option.apply(sortable, args);
				}
			}
		});

		return (retVal === void 0) ? this : retVal;
	};
});
