// SEO Analyser
var D_seo_analyser = {
	setting: {
        analyser: $('.d-seo-analyser'),
		color_code : {
			'default' : '#e5e5e5',
			'danger' : '#cf4949',
			'warning' : '#f1a050',
			'success' : '#86ce99'
		}
    },
	
	init: function(setting) {
		this.setting = $.extend({}, this.setting, setting);
		
		var $this = this;
		var analyser = this.setting.analyser; 
				
		analyser.find('.btn-analyse').on('click', function(event) {
			event.preventDefault();
			
			$this.analyse();
		});
		
		analyser.find('.btn-send').on('click', function(event) {
			event.preventDefault();
			
			$this.send();
		});
		
		analyser.find('.popup-overlay').on('click', function(event) {
			analyser.find('.popup-overlay').fadeOut(500);
			analyser.find('.popup-option').fadeOut(500);
			analyser.find('.popup-message').fadeOut(500);
		});
	},
	
	analyse: function() {
		var $this = this;
		var analyser = this.setting.analyser;
		
		$.ajax({
			type: 'get',
			url: analyser.find('.form').attr('action'),
			data: analyser.find('.form').serialize(),
			dataType: 'json',
			beforeSend: function() {
				analyser.find('.btn-analyse').prop('disabled', true);
				analyser.find('.btn-analyse').button('loading');
			},
			success: function(data) {
				$this.showAlert(data);
								
				if ((data.error != '') || data.result) {
					analyser.find('.btn-analyse').button('reset');
					analyser.find('.btn-analyse').prop('disabled', false);
					analyser.find('.analyse-progress').addClass('hide');
					analyser.find('.progress-bar').attr('aria-valuenow', '0').css('width', '0%');	
					analyser.find('.progress-info').html('');
					analyser.find('.progress-text').html('');
				} 
				
				if (data.progress) {
					$this.progress(data.progress);
				}
				
				if (data.result) {
					analyser.find('.analyse-result').html(data.result);
					
					$this.updateResult();
					
					setTimeout(function() {
						analyser.find('.popup-overlay').fadeIn(500);
						analyser.find('.popup-option').fadeIn(500);
					}, 2000);
				}
			},
			error: function(xhr, ajaxOptions, thrownError) {
				console.log(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
			}
		});
	},
	
	progress: function(progress) {
		var $this = this;
		var analyser = this.setting.analyser;
		
		analyser.find('.progress-bar').attr('aria-valuenow', progress.value).css('width', progress.value + '%');	
		analyser.find('.progress-info').html(progress.info);
		analyser.find('.progress-text').html(progress.text + '<strong>%</strong>');
		analyser.find('.analyse-progress').removeClass('hide');
		analyser.find('.analyse-result').html('');
				
		if (!window.EventSource) {
			return;
		}
					
		if (!!window.EventSource) {
			var eventSource = new EventSource(analyser.find('.form').attr('action').replace('/analyse', '/progress') + '&' + analyser.find('.form').serialize());
						
			eventSource.addEventListener('progress', function(e) {
				var progress = JSON.parse(e.data);
				
				analyser.find('.progress-bar').attr('aria-valuenow', progress.value).css('width', progress.value + '%');	
				analyser.find('.progress-info').html(progress.info);
				analyser.find('.progress-text').html(progress.text + '<strong>%</strong>');
										
				if (progress.value == 100) {
					eventSource.close();
						
					$this.analyse();
				}
			});
		}
	},
	
	send: function() {
		var $this = this;
		var analyser = this.setting.analyser;
		
		$.ajax({
			type: 'get',
			url: analyser.find('.form').attr('action').replace('/analyse', '/send'),
			data: analyser.find('.form').serialize(),
			dataType: 'json',
			beforeSend: function() {
				analyser.find('.btn-send').prop('disabled', true);
				analyser.find('.btn-send').button('loading');
			},
			complete: function() {
				analyser.find('.btn-send').button('reset');
				analyser.find('.btn-send').prop('disabled', false);
			},
			success: function(data) {
				$this.showAlert(data);

				if (data['success']) {
					analyser.find('.popup-message').html('<div class="message">' + data['success'] + '</div>');
					analyser.find('.popup-option').fadeOut();
					analyser.find('.popup-message').fadeIn();
					
					$.ajax({
						type: 'get',
						url: analyser.find('.form').attr('action').replace('/analyse', '/send'),
						data: analyser.find('.form').serialize(),
						dataType: 'json',
						success: function(data) {
					
						},
						error: function(xhr, ajaxOptions, thrownError) {
							console.log(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
						}
					});
				}
			},
			error: function(xhr, ajaxOptions, thrownError) {
				console.log(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
			}
		});
	},
			
	showAlert: function(data) {
		var analyser = this.setting.analyser;
		var form = analyser.find('.form');
		
		form.find('.alert, .text-danger').remove();
		form.find('.row').removeClass('has-error');

		if (data['error']) {
			if (data['error']['warning']) {
				form.find('#result').prepend('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + data['error']['warning'] + '</div>');
			}

			for (i in data['error']) {
				var element = form.find('.form-' + i);
			
				if (element.parent().hasClass('btn-group')) {
					$(element).parent().after('<div class="text-danger">' + data['error'][i] + '</div>');
				} else {
					$(element).after('<div class="text-danger">' + data['error'][i] + '</div>');
				}
			}

			form.find('.text-danger').parents('.row').addClass('has-error');
		}
	},
		
	updateResult: function() {
		var analyser = this.setting.analyser; 
		var color_code = this.setting.color_code;
		
		analyser.find('.page-header').on('click', function() {
			$(this).toggleClass('collapsed');
		});
	
		analyser.find('.chart').each(function(index) {
			var ctx = $(this);
		
			var chart = new Chart(ctx, {
				type: 'doughnut',
				data: {
					datasets: [{
						backgroundColor: [color_code[ctx.attr('color_code')], color_code['default']],
						data: [ctx.attr('value'), (100 - ctx.attr('value'))],
					}],
				},
				options: {
					tooltips: {
						enabled: false
					}
				}
			});
		});		
	}
};

$(document).ready(function() {
	d_seo_analyser = $.extend(true, {}, D_seo_analyser);
	
    d_seo_analyser.init({
        analyser: $('.d-seo-analyser')
    });
});
