// SEO Analyser
var D_seo_analyser = {
	setting: {
        analyser: $('.d-seo-analyser'),
		color_code : {
			'default' : '#e5e5e5',
			'danger' : '#cf4949',
			'warning' : '#f1a050',
			'success' : '#86ce99'
		}
    },
	
	init: function(setting) {
		this.setting = $.extend({}, this.setting, setting);
		
		var $this = this;
		var analyser = this.setting.analyser; 	
		var color_code = this.setting.color_code;
		
		analyser.find('.page-header').on('click', function() {
			$(this).toggleClass('collapsed');
		});
	
		analyser.find('.chart').each(function(index) {
			var ctx = $(this);
		
			var chart = new Chart(ctx, {
				type: 'doughnut',
				data: {
					datasets: [{
						backgroundColor: [color_code[ctx.attr('color_code')], color_code['default']],
						data: [ctx.attr('value'), (100 - ctx.attr('value'))],
					}],
				},
				options: {
					tooltips: {
						enabled: false
					}
				}
			});
		});		
	}
};

$(document).ready(function() {
	d_seo_analyser = $.extend(true, {}, D_seo_analyser);
	
    d_seo_analyser.init({
        analyser: $('.d-seo-analyser')
    });
});
